---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：121-Webhook一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **Webhookの最大数制限の詳細仕様**：Limitableモジュールの具体的な制限値が未確認
  2. **カスタムWebhookテンプレートの詳細仕様**：テンプレート構文の詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/hooks_controller.rb`
- E-02: `app/views/projects/hooks/index.html.haml`
- E-03: `app/views/shared/web_hooks/_index.html.haml`
- E-04: `app/views/shared/web_hooks/_form.html.haml`
- E-05: `app/models/hooks/project_hook.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/hooks` | E-01 (14行目 layout指定, ルーティング慣例) | ○ |
| C-02 | `read_web_hook`権限で閲覧可能 | E-01 (7行目 authorize_read_hook!) | ○ |
| C-03 | `admin_web_hook`権限で作成・編集・削除可能 | E-01 (8行目 authorize_admin_hook!) | ○ |
| C-04 | トリガーイベントにpush_events等が含まれる | E-05 (9-26行目 AVAILABLE_HOOKS) | ○ |
| C-05 | テスト実行は`TestHooks::ProjectService`を使用 | E-01 (19行目) | ○ |
| C-06 | レート制限がテスト実行に適用される | E-01 (9行目 check_rate_limit!) | ○ |
| C-07 | 新規Webhookフォームにはurl, token, trigger等がある | E-04 (全体) | ○ |
| C-08 | SSL検証オプションが存在する | E-04 (13-16行目) | ○ |
| C-09 | カスタムWebhookテンプレート入力がある | E-04 (7-10行目) | ○ |
| C-10 | 一覧はCrudComponentで表示される | E-03 (1行目) | ○ |
| C-11 | 画面Noは121、画面名はWebhook一覧 | E-06 (122行目) | ○ |
| C-12 | 機能No.92プロジェクトWebhookと関連 | E-07 (171行目) | ○ |
| C-13 | ProjectHookはWebHookを継承 | E-05 (3行目) | ○ |
| C-14 | projectとの関連がある | E-05 (34-35行目 belongs_to :project) | ○ |
| C-15 | web_hook_logsとの関連がある | E-05 (32行目 has_many :web_hook_logs) | ○ |
| C-16 | LayoutはSettingsSectionComponentを使用 | E-02 (5行目) | ○ |
| C-17 | Limitableモジュールで制限される | E-05 (5行目 include Limitable) | △ |
| C-18 | カスタムテンプレートの最大長は4096文字 | E-04 (8行目 maxlength: 4096) | ○ |

## 4) 不足情報（Unknown / Missing）
- Limitableモジュールによる具体的なWebhook数制限値の詳細
  - 候補：`app/models/concerns/limitable.rb` / アプリケーション設定 / プラン別制限設定
- カスタムWebhookテンプレートの構文仕様
  - 候補：ヘルプドキュメント / テンプレートパーサー実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD機能の設計は確認済み
- 1: 中リスク - Limitableの制限値は運用環境により異なる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] URLルーティングが実際の環境と一致するか確認
- [ ] 権限チェックの動作が正しいか確認
- [ ] トリガーイベントの選択肢が最新か確認
- [ ] カスタムテンプレートの使用方法がユーザーに理解できるか確認
