---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：122-Webhook編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **シークレットトークンの表示制御**：画面上での非表示処理の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/hooks_controller.rb`
- E-02: `app/views/projects/hooks/edit.html.haml`
- E-03: `app/views/shared/web_hooks/_form.html.haml`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/hooks/:id/edit` | E-01, E-02 (ルーティング慣例) | ○ |
| C-02 | `admin_web_hook`権限が必要 | E-01 (8行目 authorize_admin_hook!) | ○ |
| C-03 | 保存ボタンで設定を更新 | E-02 (15行目 f.submit) | ○ |
| C-04 | テストボタンでWebhookテスト実行 | E-02 (16行目 _test_button) | ○ |
| C-05 | 削除ボタンで確認ダイアログ表示 | E-02 (18行目 data: { confirm: ... }) | ○ |
| C-06 | 削除確認メッセージは英語で表示 | E-02 (18行目 confirm_btn_variant) | ○ |
| C-07 | エラー情報が画面上部に表示される | E-02 (4行目 _hook_errors) | ○ |
| C-08 | ログ一覧が画面下部に表示される | E-02 (23行目 hook_logs/_index) | ○ |
| C-09 | Closeボタンで一覧画面に戻る | E-02 (19行目 link_button_to) | ○ |
| C-10 | 画面Noは122、画面名はWebhook編集 | E-04 (123行目) | ○ |
| C-11 | 機能No.92プロジェクトWebhookと関連 | E-05 (172行目) | ○ |
| C-12 | テスト実行にはレート制限が適用される | E-01 (9行目 check_rate_limit!) | ○ |
| C-13 | TestHooks::ProjectServiceでテスト実行 | E-01 (19行目) | ○ |
| C-14 | レイアウトはproject_settings | E-01 (13行目 layout) | ○ |
| C-15 | gitlab_ui_form_forでフォーム生成 | E-02 (10行目) | ○ |
| C-16 | シークレットトークンは保存後非表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- シークレットトークンの表示/非表示ロジックの詳細
  - 候補：`app/views/shared/web_hooks/_form.html.haml` / WebHookモデルのattr_accessor

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 編集画面の基本構造は明確
- 0: 低リスク - 削除処理のフローは確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 削除確認ダイアログが正しく表示されるか確認
- [ ] テスト実行後のログが正しく記録されるか確認
- [ ] シークレットトークンの安全な取り扱いを確認
- [ ] エラー表示が適切か確認
