---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：123-デプロイキー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/deploy_keys_controller.rb`
- E-02: `app/views/projects/deploy_keys/edit.html.haml`
- E-03: `app/views/shared/deploy_keys/_form.html.haml`
- E-04: `app/models/deploy_key.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/deploy_keys/:id/edit` | E-01 | ○ |
| C-02 | `admin_project`権限が必要 | E-01 (9行目 authorize_admin_project!) | ○ |
| C-03 | タイトル変更は`update_deploy_key_title`権限が必要 | E-03 (9行目 readonly条件) | ○ |
| C-04 | can_pushで書き込み権限を制御 | E-03 (39-42行目) | ○ |
| C-05 | フィンガープリントは読み取り専用で表示 | E-03 (25-32行目 readonly) | ○ |
| C-06 | 成功時メッセージ「Deploy key was successfully updated.」 | E-01 (72行目) | ○ |
| C-07 | リポジトリ設定へリダイレクト | E-01 (137-139行目) | ○ |
| C-08 | キャンセルボタンでリポジトリ設定へ戻る | E-02 (10行目) | ○ |
| C-09 | 画面Noは123、画面名はデプロイキー編集 | E-05 (124行目) | ○ |
| C-10 | 機能No.57デプロイキー管理と関連 | E-06 (173行目) | ○ |
| C-11 | DeployKeyはKeyを継承 | E-04 (3行目 class DeployKey < Key) | ○ |
| C-12 | deploy_keys_projectsと多対多関連 | E-04 (11行目 has_many) | ○ |
| C-13 | レイアウトはproject_settings | E-01 (12行目) | ○ |
| C-14 | 有効期限は編集時は読み取り専用 | E-03 (33-36行目 readonly) | ○ |
| C-15 | authorize_update_deploy_key!で更新権限チェック | E-01 (128-133行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な編集機能の実装は確認済み
- 0: 低リスク - 権限チェックのロジックは明確

## 6) レビュアーチェックリスト（最小）
- [ ] タイトル変更の権限制御が正しく動作するか確認
- [ ] can_pushの設定変更が正しく反映されるか確認
- [ ] 複数プロジェクト共有時のタイトル変更影響を確認
