---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：124-メンバー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **昇格保留中メンバー数表示**：EE機能の詳細実装確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/project_members_controller.rb`
- E-02: `app/views/projects/project_members/index.html.haml`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/project_members` | E-01 | ○ |
| C-02 | `admin_project_member`権限で管理機能が使える | E-01 (10行目) | ○ |
| C-03 | 招待中メンバーは管理者権限で表示 | E-01 (21-23行目) | ○ |
| C-04 | Vue.jsアプリでレンダリング | E-02 (39行目 .js-project-members-list-app) | ○ |
| C-05 | メンバー招待ダイアログがある | E-02 (33-37行目 .js-invite-members-trigger) | ○ |
| C-06 | グループ招待ダイアログがある | E-02 (28-31行目 .js-invite-group-trigger) | ○ |
| C-07 | メンバーインポート機能がある | E-02 (24-27行目 .js-import-project-members) | ○ |
| C-08 | 直接/継承メンバーの切り替えがある | E-01 (17行目 @include_relations) | ○ |
| C-09 | ページネーション対応 | E-01 (26行目 .page()) | ○ |
| C-10 | MembersFinderでメンバー検索 | E-01 (35-37行目) | ○ |
| C-11 | 画面Noは124、画面名はメンバー一覧 | E-03 (125行目) | ○ |
| C-12 | 機能No.84プロジェクトメンバー管理と関連 | E-04 (174行目) | ○ |
| C-13 | 機能No.86招待機能と関連 | E-04 (175行目) | ○ |
| C-14 | メンバーガイドライン表示がある | E-02 (12-14行目) | ○ |
| C-15 | group_member_linksはFeatureフラグで制御 | E-01 (19行目) | ○ |
| C-16 | 検索・ソート機能がある | E-01 (16行目, 72行目) | ○ |
| C-17 | アクセス要求者の表示がある | E-01 (23行目) | ○ |
| C-18 | 昇格保留中メンバー数を表示 | E-02 (pending_members_count参照) | △ |

## 4) 不足情報（Unknown / Missing）
- 昇格保留中メンバー機能の詳細実装（EE機能）
  - 候補：`ee/app/helpers/`内のヘルパー / EE専用コントローラー

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メンバー一覧の基本機能は確認済み
- 1: 中リスク - Vue.jsアプリの詳細動作は別途フロントエンドコード確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] メンバー招待ダイアログが正しく動作するか確認
- [ ] グループ招待機能の制限条件を確認
- [ ] 権限によるUI表示切り替えが正しいか確認
- [ ] ページネーションが正しく動作するか確認
