---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：125-セキュリティ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ機能一覧の詳細**：EE機能を含む全機能の有効状態取得ロジック確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/security/configuration_controller.rb`
- E-02: `app/views/projects/security/configuration/show.html.haml`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/security/configuration` | E-01 | ○ |
| C-02 | `read_security_configuration`権限が必要 | E-01 (12行目) | ○ |
| C-03 | ConfigurationPresenterでデータ整形 | E-01 (14行目, 30-31行目) | ○ |
| C-04 | Vue.jsアプリ（#js-security-configuration）でレンダリング | E-02 (4行目) | ○ |
| C-05 | vulnerability_training_docs_pathを提供 | E-02 (5行目) | ○ |
| C-06 | security_upgrade_pathを提供 | E-02 (6行目) | ○ |
| C-07 | can_read_attributesで読み取り権限チェック | E-02 (9行目) | ○ |
| C-08 | can_manage_attributesで管理権限チェック | E-02 (10行目) | ○ |
| C-09 | group_manage_attributes_pathを提供 | E-02 (11行目) | ○ |
| C-10 | 画面Noは125、画面名はセキュリティ設定 | E-03 (126行目) | ○ |
| C-11 | 機能No.65脆弱性スキャンと関連 | E-04 (176行目) | ○ |
| C-12 | HTML/JSONレスポンス対応 | E-01 (16-20行目) | ○ |
| C-13 | feature_categoryはstatic_application_security_testing | E-01 (8行目) | ○ |
| C-14 | SAST, DAST, 依存関係スキャン等の機能一覧を表示 | **根拠なし（プレゼンター詳細要確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- ConfigurationPresenterの詳細実装（利用可能機能の判定ロジック）
  - 候補：`app/presenters/projects/security/configuration_presenter.rb` / EE版プレゼンター

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面の基本構造は確認済み
- 1: 中リスク - EE限定機能の表示条件は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 権限チェックが正しく動作するか確認
- [ ] 各セキュリティ機能の有効化状態が正しく表示されるか確認
- [ ] Ultimate限定機能の表示が適切か確認
- [ ] Vue.jsアプリが正しくレンダリングされるか確認
