---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：126-使用量クォータ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/usage_quotas_controller.rb`
- E-02: `app/views/projects/usage_quotas/index.html.haml`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/-/usage_quotas` | E-01 | ○ |
| C-02 | `read_usage_quotas`権限が必要 | E-01 (5行目) | ○ |
| C-03 | Vue.jsアプリ（#js-storage-usage-app）でレンダリング | E-02 (16行目) | ○ |
| C-04 | レイアウトはproject_settings | E-01 (10行目) | ○ |
| C-05 | 検索設定は非表示 | E-01 (16行目 @hide_search_settings) | ○ |
| C-06 | フィーチャーフラグproject_repositories_health_uiを使用 | E-01 (7行目) | ○ |
| C-07 | 再計算アラートが定義されている | E-02 (1-6行目) | ○ |
| C-08 | サブタイトルにプロジェクト名を表示 | E-02 (9-10行目) | ○ |
| C-09 | ヘルプドキュメントへのリンクがある | E-02 (12-13行目) | ○ |
| C-10 | 転送タブはEE機能 | E-02 (17行目 render_if_exists) | ○ |
| C-11 | ObservabilityタブはEE機能 | E-02 (18行目 render_if_exists) | ○ |
| C-12 | PagesタブはEE機能 | E-02 (19行目 render_if_exists) | ○ |
| C-13 | 画面Noは126、画面名は使用量クォータ | E-03 (127行目) | ○ |
| C-14 | 機能No.8プロジェクト統計と関連 | E-04 (179行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な表示機能の実装は確認済み
- 0: 低リスク - EE機能の存在も明確

## 6) レビュアーチェックリスト（最小）
- [ ] ストレージ使用量が正しく表示されるか確認
- [ ] 再計算機能が正しく動作するか確認
- [ ] EEタブがライセンスに応じて表示されるか確認
