---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：127-Pages設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pages_controller.rb`
- E-02: `app/views/projects/pages/show.html.haml`
- E-03: `app/models/pages_domain.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/pages` | E-01 | ○ |
| C-02 | `read_pages`権限で閲覧可能 | E-01 (5行目) | ○ |
| C-03 | `update_pages`権限で設定変更可能 | E-01 (6行目) | ○ |
| C-04 | `remove_pages`権限で削除可能 | E-01 (7行目) | ○ |
| C-05 | 未デプロイ時はオンボーディング画面へリダイレクト | E-01 (20-22行目) | ○ |
| C-06 | ドメイン一覧を取得しpresentで変換 | E-01 (26行目) | ○ |
| C-07 | Pages::DeleteServiceで削除処理 | E-01 (31行目) | ○ |
| C-08 | 削除成功時「Pages were scheduled for removal」表示 | E-01 (35行目) | ○ |
| C-09 | regenerate_unique_domainアクションがある | E-01 (56-71行目) | ○ |
| C-10 | タブ構成（Overview, Domains & settings） | E-02 (9-12行目) | ○ |
| C-11 | Vue.jsアプリ（#js-pages）でOverview表示 | E-02 (16-19行目) | ○ |
| C-12 | SSL制限警告はサブドメインにドットを含む場合 | E-02 (23行目) | ○ |
| C-13 | カスタムドメインはconfig設定で有効化 | E-02 (24行目) | ○ |
| C-14 | 画面Noは127、画面名はPages設定 | E-04 (128行目) | ○ |
| C-15 | 機能No.129 GitLab Pagesと関連 | E-05 (180行目) | ○ |
| C-16 | pages_https_onlyでHTTPS強制 | E-01 (81行目) | ○ |
| C-17 | pages_unique_domain_enabled設定がある | E-01 (88行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なPages設定機能は確認済み
- 0: 低リスク - 権限制御も明確

## 6) レビュアーチェックリスト（最小）
- [ ] Pages未デプロイ時のリダイレクトが正しく動作するか確認
- [ ] カスタムドメイン一覧が正しく表示されるか確認
- [ ] HTTPS設定の保存が正しく動作するか確認
- [ ] Pages削除処理が正しく動作するか確認
