---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：128-Pagesドメイン詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/pages_domains_controller.rb`
- E-02: `app/views/projects/pages_domains/show.html.haml`
- E-03: `app/views/projects/pages_domains/_form.html.haml`
- E-04: `app/models/pages_domain.rb`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパターンは `/:namespace/:project/pages/domains/:domain` | E-01 | ○ |
| C-02 | `update_pages`権限が必要 | E-01 (7行目) | ○ |
| C-03 | domain_presenterでプレゼンター変換 | E-01 (104-106行目) | ○ |
| C-04 | 未検証時に警告メッセージ表示 | E-01 (14-17行目) | ○ |
| C-05 | VerifyPagesDomainServiceで検証処理 | E-01 (25行目) | ○ |
| C-06 | 検証成功時「Successfully verified domain ownership」表示 | E-01 (28行目) | ○ |
| C-07 | RetryAcmeOrderServiceで証明書リトライ | E-01 (36-37行目) | ○ |
| C-08 | Pages::Domains::UpdateServiceで更新処理 | E-01 (57行目) | ○ |
| C-09 | 更新成功時「Domain was updated」表示 | E-01 (60-62行目) | ○ |
| C-10 | clean_certificateで証明書クリア | E-01 (81-88行目) | ○ |
| C-11 | gitlab_ui_form_forでフォーム生成 | E-02 (10行目) | ○ |
| C-12 | 保存・キャンセルボタンがある | E-02 (13-14行目) | ○ |
| C-13 | ドメイン名は読み取り専用 | E-03 (9-12行目) | ○ |
| C-14 | カスタム証明書無効時にメッセージ表示 | E-03 (25-26行目) | ○ |
| C-15 | 画面Noは128、画面名はPagesドメイン詳細 | E-05 (129行目) | ○ |
| C-16 | 機能No.130 Pagesドメイン管理と関連 | E-06 (181行目) | ○ |
| C-17 | 検証コードにプレフィックスが付く | E-04 (9行目 VERIFICATION_KEY) | ○ |
| C-18 | 証明書は暗号化保存 | E-04 (49-53行目 attr_encrypted) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ドメイン詳細画面の実装は確認済み
- 0: 低リスク - 検証・証明書処理のフローも明確

## 6) レビュアーチェックリスト（最小）
- [ ] ドメイン検証が正しく動作するか確認
- [ ] SSL証明書設定が正しく保存されるか確認
- [ ] Let's Encryptリトライが正しく動作するか確認
- [ ] 証明書クリアが正しく動作するか確認
