---
generated_at: 2026-01-22 11:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：131-Runner新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL Mutation詳細**：フロントエンドコード未確認
  2. **Vueコンポーネント構造**：具体的なコンポーネント実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/runners/new.html.haml`（行1-6）
- E-02: `app/controllers/projects/runners_controller.rb`（行3-30）
- E-03: `app/models/ci/runner.rb`（行1-100、バリデーション・enum定義）
- E-04: `app/models/ci/runner.rb`（行38-57、enum定義）
- E-05: `app/models/ci/runner.rb`（行22-36、トークン生成）
- E-06: `app/models/ci/runner.rb`（行60-62、トークンプレフィックス）
- E-07: `app/models/ci/runner.rb`（行82、REGISTRATION_AVAILABILITY_TIME）
- E-08: `app/models/ci/runner.rb`（行94、TAG_LIST_MAX_LENGTH）
- E-09: `config/routes/project.rb`（行102-107、ルーティング定義）
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行184）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビューはVueコンポーネント `#js-project-new-runner` をマウント | E-01 | ○ |
| C-02 | data属性で project_id を Global ID 形式で渡す | E-01 | ○ |
| C-03 | `authorize_create_runners!` による権限チェック | E-02 | ○ |
| C-04 | newアクションは空（ビューレンダリングのみ） | E-02 | ○ |
| C-05 | runner_typeはinstance_type/group_type/project_typeの3種 | E-04 | ○ |
| C-06 | access_levelはnot_protected/ref_protectedの2種 | E-03 | ○ |
| C-07 | creation_stateはstarted/finishedの2種 | E-04 | ○ |
| C-08 | registration_typeはregistration_token/authenticated_userの2種 | E-04 | ○ |
| C-09 | トークンにglrt-プレフィックスが付与される | E-06 | ○ |
| C-10 | Runner作成後1時間以内に登録完了が必要 | E-07 | ○ |
| C-11 | タグ最大50個制限 | E-08 | ○ |
| C-12 | URLパスは `/:namespace/:project/-/runners/new` | E-09 | ○ |
| C-13 | 関連機能No.51 Runnerレジストレーション | E-10 | ○ |
| C-14 | descriptionは最大1024文字 | E-03 | ○ |
| C-15 | maximum_timeoutは10分以上 | E-03 | ○ |
| C-16 | トークンは暗号化保存 | E-05 | ○ |
| C-17 | GraphQL Mutation `runnerCreate` による作成 | **根拠なし** | △ |
| C-18 | Ci::Runners::CreateRunnerService による処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutation の具体的な実装（`app/graphql/mutations/ci/runner/create.rb`）を直接確認していない
  - 候補：GraphQL schema定義 / Mutationファイル / サービスクラス
- Vueコンポーネントの具体的な実装（`app/assets/javascripts/ci/runner/project_new_runner/`）を確認していない
  - 候補：index.js / app.vue / コンポーネント群

## 5) リスクフラグ（レビュー観点）
- 0: データモデル定義（runner.rb）- 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 0: コントローラ処理 - 直接確認済み
- 1: フロントエンド実装 - 間接的な推測含む
- 1: GraphQL API - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] Vueコンポーネント `#js-project-new-runner` の実装が設計書の記述と一致するか確認
- [ ] GraphQL Mutation `runnerCreate` の存在と引数を確認
- [ ] Runner作成時の権限チェックフローが正確か確認
- [ ] トークン生成とプレフィックス付与の仕組みを確認
