---
generated_at: 2026-01-22 11:32:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：132-Runner編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL Mutation詳細**：フロントエンドコード未確認
  2. **Vueコンポーネント構造**：具体的なコンポーネント実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/runners/edit.html.haml`（行1-7）
- E-02: `app/controllers/projects/runners_controller.rb`（行3-28）
- E-03: `app/controllers/projects/runners_controller.rb`（行79-85、runner取得・サービス呼出）
- E-04: `app/models/ci/runner.rb`（行91、FORM_EDITABLE定義）
- E-05: `app/models/ci/runner.rb`（行245-279、バリデーション）
- E-06: `config/routes/project.rb`（行102-107、ルーティング定義）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行185）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ビューはVueコンポーネント `#js-project-runner-edit` をマウント | E-01 | ○ |
| C-02 | data属性で runner_id と runner_path を渡す | E-01 | ○ |
| C-03 | `authorize_runner!(:update_runner)` による権限チェック | E-02 | ○ |
| C-04 | editアクションは空（ビューレンダリングのみ） | E-02 | ○ |
| C-05 | FORM_EDITABLEで編集可能項目が定義されている | E-04 | ○ |
| C-06 | descriptionは最大1024文字 | E-05 | ○ |
| C-07 | maximum_timeoutは10分以上 | E-05 | ○ |
| C-08 | タグ最大50個制限 | E-05 | ○ |
| C-09 | URLパスは `/:namespace/:project/-/runners/:id/edit` | E-06 | ○ |
| C-10 | 関連機能No.51 Runnerレジストレーション | E-07 | ○ |
| C-11 | runner_short_nameでRunner短縮名を表示 | E-01 | ○ |
| C-12 | Ci::Runners::UpdateRunnerService による更新処理 | E-03 | ○ |
| C-13 | パンくずリストにCI/CD Settings, Runner名, Editが表示 | E-01 | ○ |
| C-14 | maintenance_note（maintainer_note）は最大1024文字 | E-05 | ○ |
| C-15 | GraphQL Mutation `runnerUpdate` による更新 | **根拠なし** | △ |
| C-16 | Vueコンポーネントの具体的な構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutation の具体的な実装（`app/graphql/mutations/ci/runner/update.rb`）を直接確認していない
  - 候補：GraphQL schema定義 / Mutationファイル / サービスクラス
- Vueコンポーネントの具体的な実装（`app/assets/javascripts/ci/runner/project_runner_edit/`）を確認していない
  - 候補：index.js / app.vue / コンポーネント群

## 5) リスクフラグ（レビュー観点）
- 0: データモデル定義（runner.rb）- 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 0: コントローラ処理 - 直接確認済み
- 0: ビューテンプレート - 直接確認済み
- 1: フロントエンド実装 - 間接的な推測含む
- 1: GraphQL API - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] Vueコンポーネント `#js-project-runner-edit` の実装が設計書の記述と一致するか確認
- [ ] GraphQL Mutation `runnerUpdate` の存在と引数を確認
- [ ] FORM_EDITABLEの項目がVueフォームと一致するか確認
- [ ] runner_short_nameヘルパーメソッドの動作を確認
