---
generated_at: 2026-01-22 11:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：133-Hookログ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **HookLogモデル詳細**：モデルファイル未直接確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/hook_logs/show.html.haml`（行1-16）
- E-02: `app/controllers/projects/hook_logs_controller.rb`（行1-23）
- E-03: `app/views/shared/hook_logs/_content.html.haml`（行1-53）
- E-04: `config/routes/project.rb`（行451-460、ルーティング定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行186）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パンくずリストにWebhook settingsへのリンクを表示 | E-01 | ○ |
| C-02 | ページタイトルは「Webhook logs」 | E-01 | ○ |
| C-03 | Resend Requestボタンが存在 | E-01 | ○ |
| C-04 | oversizeの場合ボタンが無効化される | E-01 | ○ |
| C-05 | 共有パーシャル_contentでログ詳細を表示 | E-01 | ○ |
| C-06 | authorize_admin_hook!で権限チェック | E-02 | ○ |
| C-07 | HookLogActionsモジュールをinclude | E-02 | ○ |
| C-08 | レイアウトはproject_settings | E-02 | ○ |
| C-09 | hookメソッドでproject.hooksから取得 | E-02 | ○ |
| C-10 | HTTPメソッド(POST)とURLを表示 | E-03 | ○ |
| C-11 | トリガーイベント種別を表示 | E-03 | ○ |
| C-12 | 実行時間と相対時刻を表示 | E-03 | ○ |
| C-13 | 内部エラーメッセージをアラートで表示 | E-03 | ○ |
| C-14 | レスポンスボディ・ヘッダーを表示 | E-03 | ○ |
| C-15 | リクエストボディをJSON整形表示 | E-03 | ○ |
| C-16 | リクエストヘッダーを表示 | E-03 | ○ |
| C-17 | URLパスは`/:namespace/:project/-/hooks/:hook_id/hook_logs/:id` | E-04 | ○ |
| C-18 | HookLogモデルの詳細構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- HookLogモデル（`app/models/web_hook_log.rb`）を直接確認していない
  - 候補：モデル定義 / カラム定義 / バリデーション
- HookLogActionsモジュール（`app/controllers/concerns/web_hooks/hook_log_actions.rb`）を直接確認していない
  - 候補：show/retryアクションの実装詳細

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: 共有パーシャル - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: モデル構造 - 間接的な推測含む
- 1: Concernモジュール - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] web_hook_log.rb のカラム定義が設計書と一致するか確認
- [ ] HookLogActionsモジュールのshow/retryアクション実装を確認
- [ ] oversize? メソッドの閾値・判定ロジックを確認
- [ ] retry_path の生成ロジックを確認
