---
generated_at: 2026-01-22 11:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：134-インポート設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **自動リフレッシュ機構**：JavaScriptコード未確認
  2. **ヘルパーメソッド詳細**：imports_helper.rb未直接確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/imports/show.html.haml`（行1-13）
- E-02: `app/controllers/projects/imports_controller.rb`（行1-85）
- E-03: `config/routes/project.rb`（行259、ルーティング定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行187）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルはimport_in_progress_titleで生成 | E-01 | ○ |
| C-02 | ローディングアイコン（gl_loading_icon）を表示 | E-01 | ○ |
| C-03 | 外部インポート時にgit cloneコマンドを表示 | E-01 | ○ |
| C-04 | safe_import_urlでURLをサニタイズ | E-01 | ○ |
| C-05 | import_wait_and_refresh_messageで待機メッセージ表示 | E-01 | ○ |
| C-06 | CI/CDのみパラメータ時はcloneコマンド非表示 | E-01 | ○ |
| C-07 | require_namespace_project_creation_permissionで権限チェック | E-02 | ○ |
| C-08 | redirect_if_no_importでインポートなし時リダイレクト | E-02 | ○ |
| C-09 | import_finished?でインポート完了を検知 | E-02 | ○ |
| C-10 | import_failed?でインポート失敗を検知 | E-02 | ○ |
| C-11 | continue_paramsでカスタムリダイレクト先を設定可能 | E-02 | ○ |
| C-12 | フォークの場合とインポートの場合で完了メッセージが異なる | E-02 | ○ |
| C-13 | URLパスは `/:namespace/:project/import` | E-03 | ○ |
| C-14 | 関連機能No.105 GitHubインポート | E-04 | ○ |
| C-15 | JavaScriptによる自動リフレッシュ機構 | **根拠なし** | △ |
| C-16 | imports_helper.rbのヘルパーメソッド詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- imports_helper.rb（`app/helpers/imports_helper.rb`）を直接確認していない
  - 候補：import_in_progress_title / import_wait_and_refresh_message メソッドの実装
- JavaScriptによる自動リフレッシュの実装を確認していない
  - 候補：app/assets/javascripts内のインポート関連JS

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: ヘルパーメソッド - 間接的な推測含む
- 1: 自動リフレッシュ - JavaScriptコード未確認

## 6) レビュアーチェックリスト（最小）
- [ ] imports_helper.rbのヘルパーメソッド実装を確認
- [ ] 自動リフレッシュのJavaScript実装を確認
- [ ] safe_import_urlのサニタイズロジックを確認
- [ ] ContinueParamsモジュールの動作を確認
