---
generated_at: 2026-01-22 11:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：135-インポート開始

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **URL暗号化詳細**：暗号化の具体的な実装未確認
  2. **ImportUrlParams詳細**：Concernの具体的な処理未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/imports/new.html.haml`（行1-9）
- E-02: `app/controllers/projects/imports_controller.rb`（行1-85）
- E-03: `app/views/shared/_import_form.html.haml`（行1-42）
- E-04: `config/routes/project.rb`（行259、ルーティング定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行188）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは「Import repository」 | E-01 | ○ |
| C-02 | PageHeadingComponentで見出し表示 | E-01 | ○ |
| C-03 | gitlab_ui_form_forでフォーム生成 | E-01 | ○ |
| C-04 | shared/_import_formパーシャルを使用 | E-01 | ○ |
| C-05 | authorize_admin_project!で権限チェック | E-02 | ○ |
| C-06 | require_no_repoでリポジトリ存在チェック | E-02 | ○ |
| C-07 | redirect_if_progressでインポート進行中チェック | E-02 | ○ |
| C-08 | createアクションでproject.updateを実行 | E-02 | ○ |
| C-09 | import_state.reset.scheduleでジョブスケジュール | E-02 | ○ |
| C-10 | フォームにhttp/https/gitプロトコル説明を表示 | E-03 | ○ |
| C-11 | HTTPリダイレクト非対応の説明を表示 | E-03 | ○ |
| C-12 | 認証情報の説明を表示 | E-03 | ○ |
| C-13 | import_urlフィールドをサニタイズ表示 | E-03 | ○ |
| C-14 | エラーアラート（js-import-url-error）を表示 | E-03 | ○ |
| C-15 | import_url_user、import_url_passwordフィールド | E-03 | ○ |
| C-16 | URLパスは `/:namespace/:project/import/new` | E-04 | ○ |
| C-17 | import_urlは暗号化保存される | **根拠なし** | △ |
| C-18 | ImportUrlParamsの具体的な処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ImportUrlParams Concern（`app/controllers/concerns/import_url_params.rb`）を直接確認していない
  - 候補：URL・認証情報のマージロジック
- import_urlの暗号化実装を直接確認していない
  - 候補：attr_encrypted設定 / Gitlab::UrlSanitizer

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: 共有パーシャル - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: Concern実装 - 間接的な推測含む
- 1: 暗号化処理 - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] ImportUrlParams Concernの実装を確認
- [ ] import_urlの暗号化設定を確認
- [ ] Gitlab::UrlSanitizerの動作を確認
- [ ] import_state.reset.scheduleの処理フローを確認
