---
generated_at: 2026-01-22 11:46:00
metrics:
  claims_total: 16
  claims_with_evidence: 13
  claims_without_evidence: 3
confidence_derived: 0.81
---

# 根拠レポート：136-Jiraインポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.81**
  - 根拠あり：13 / 16、根拠なし：3
- 優先レビュー（高）
  1. **Vueコンポーネント詳細**：フロントエンドコード未確認
  2. **JiraImportモデル**：モデルファイル未確認
  3. **GraphQL Mutation**：Mutation実装未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/import/jira/show.html.haml`（行1-7）
- E-02: `app/controllers/projects/import/jira_controller.rb`（行1-38）
- E-03: `config/routes/project.rb`（行429-430、ルーティング定義）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行189）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Vueコンポーネント `.js-jira-import-root` をマウント | E-01 | ○ |
| C-02 | data属性で project_path を渡す | E-01 | ○ |
| C-03 | data属性で issues_path を渡す | E-01 | ○ |
| C-04 | data属性で jira_integration_path を渡す | E-01 | ○ |
| C-05 | data属性で is_jira_configured を渡す | E-01 | ○ |
| C-06 | data属性で project_id を渡す | E-01 | ○ |
| C-07 | data属性で setup_illustration を渡す | E-01 | ○ |
| C-08 | authenticate_user! でログインチェック | E-02 | ○ |
| C-09 | authorize_read_project! で権限チェック | E-02 | ○ |
| C-10 | validate_jira_import_settings! でバリデーション | E-02 | ○ |
| C-11 | バリデーション失敗時に課題一覧へリダイレクト | E-02 | ○ |
| C-12 | URLパスは `/:namespace/:project/-/import/jira` | E-03 | ○ |
| C-13 | 関連機能No.96 Jira連携 | E-04 | ○ |
| C-14 | JiraImportモデルの具体的な構造 | **根拠なし** | △ |
| C-15 | Vueコンポーネントの内部構造 | **根拠なし** | △ |
| C-16 | GraphQL Mutationによるインポート開始 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- JiraImportモデル（`app/models/jira_import.rb`）を直接確認していない
  - 候補：モデル定義 / ステータス管理 / リレーション
- Vueコンポーネント（`app/assets/javascripts/jira_import/`）を直接確認していない
  - 候補：コンポーネント構造 / APIコール / 状態管理
- GraphQL Mutation を直接確認していない
  - 候補：jiraImportStart Mutation

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: モデル構造 - 間接的な推測含む
- 2: フロントエンド実装 - 未確認（主要部分）
- 2: GraphQL API - 未確認（主要部分）

## 6) レビュアーチェックリスト（最小）
- [ ] JiraImportモデルの構造を確認
- [ ] Vueコンポーネント `.js-jira-import-root` の実装を確認
- [ ] GraphQL Mutation（jiraImportStart等）の存在と引数を確認
- [ ] validate_jira_import_settings! の具体的なバリデーション内容を確認
