---
generated_at: 2026-01-22 11:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：137-スニペット一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **SnippetsFinder詳細**：Finderクラス未直接確認
  2. **共有パーシャル**：_list.html.haml未直接確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/snippets/index.html.haml`（行1-18）
- E-02: `app/controllers/projects/snippets_controller.rb`（行1-53）
- E-03: `app/models/snippet.rb`（行1-100、モデル定義）
- E-04: `config/routes/project.rb`（行433-437、ルーティング定義）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行190）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ページタイトルは「Snippets」 | E-01 | ○ |
| C-02 | スニペットが存在する場合とない場合で表示を分岐 | E-01 | ○ |
| C-03 | スコープメニュー（snippets_scope_menu）を表示 | E-01 | ○ |
| C-04 | include_privateフラグでプライベート表示を制御 | E-01 | ○ |
| C-05 | New snippetボタンを表示（権限あり時） | E-01 | ○ |
| C-06 | shared/snippets/_listでスニペット一覧を表示 | E-01 | ○ |
| C-07 | shared/empty_states/_snippetsで空状態を表示 | E-01 | ○ |
| C-08 | check_snippets_available!でスニペット機能チェック | E-02 | ○ |
| C-09 | Snippets::CountServiceで件数取得 | E-02 | ○ |
| C-10 | SnippetsFinderでスニペット取得 | E-02 | ○ |
| C-11 | inc_author、inc_statisticsで関連データ取得 | E-02 | ○ |
| C-12 | redirect_out_of_rangeでページ範囲外処理 | E-02 | ○ |
| C-13 | noteable_meta_dataでコメント数取得 | E-02 | ○ |
| C-14 | Snippetモデルでvisibility_levelを管理 | E-03 | ○ |
| C-15 | URLパスは `/:namespace/:project/-/snippets` | E-04 | ○ |
| C-16 | 関連機能No.71 プロジェクトスニペット | E-05 | ○ |
| C-17 | SnippetsFinderの具体的な検索ロジック | **根拠なし** | △ |
| C-18 | 共有パーシャル_listの具体的な表示内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SnippetsFinder（`app/finders/snippets_finder.rb`）を直接確認していない
  - 候補：スコープ・可視性・ソートの適用ロジック
- 共有パーシャル（`app/views/shared/snippets/_list.html.haml`）を直接確認していない
  - 候補：スニペットカードの表示内容・レイアウト

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: モデル定義 - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: Finderクラス - 間接的な推測含む
- 1: 共有パーシャル - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] SnippetsFinderの検索ロジックを確認
- [ ] shared/snippets/_listパーシャルの表示内容を確認
- [ ] snippets_scope_menuのタブ構成を確認
- [ ] CountServiceの件数計算ロジックを確認
