---
generated_at: 2026-01-22 11:58:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：139-スニペット新規作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **GraphQL Mutation詳細**：Mutation実装未直接確認
  2. **CreateService詳細**：サービスクラス未直接確認
  3. **Vueコンポーネント詳細**：フロントエンドコード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/snippets/new.html.haml`（行1-7）
- E-02: `app/controllers/projects/snippets_controller.rb`（行1-53）
- E-03: `app/views/shared/snippets/_form.html.haml`（行1-3）
- E-04: `app/models/snippet.rb`（行1-100、定数・バリデーション）
- E-05: `config/routes/project.rb`（行433-437、ルーティング定義）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行192）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パンくずリストにSnippets、New snippetを表示 | E-01 | ○ |
| C-02 | ページタイトルは「New snippet」 | E-01 | ○ |
| C-03 | PageHeadingComponentで見出し表示 | E-01 | ○ |
| C-04 | shared/snippets/_formパーシャルを使用 | E-01 | ○ |
| C-05 | authorize_create_snippet!で権限チェック | E-02 | ○ |
| C-06 | newアクションで空のスニペットオブジェクトを初期化 | E-02 | ○ |
| C-07 | Vueコンポーネント `#js-snippet-edit` をマウント | E-03 | ○ |
| C-08 | data属性で project_path を渡す | E-03 | ○ |
| C-09 | data属性で snippet-gid を渡す（空文字） | E-03 | ○ |
| C-10 | data属性で visibility_levels を渡す | E-03 | ○ |
| C-11 | data属性で selected_level を渡す | E-03 | ○ |
| C-12 | MAX_FILE_COUNT = 10 でファイル数制限 | E-04 | ○ |
| C-13 | DESCRIPTION_LENGTH_MAX = 1.megabyte | E-04 | ○ |
| C-14 | タイトルは最大255文字 | E-04 | ○ |
| C-15 | コンテンツは必須 | E-04 | ○ |
| C-16 | URLパスは `/:namespace/:project/-/snippets/new` | E-05 | ○ |
| C-17 | 関連機能No.71 プロジェクトスニペット | E-06 | ○ |
| C-18 | GraphQL Mutation snippetCreate による作成 | **根拠なし** | △ |
| C-19 | Snippets::CreateService による処理 | **根拠なし** | △ |
| C-20 | Vueコンポーネントの内部フォーム構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- GraphQL Mutation（`app/graphql/mutations/snippets/create.rb`）を直接確認していない
  - 候補：Mutation定義 / 引数 / 戻り値
- CreateService（`app/services/snippets/create_service.rb`）を直接確認していない
  - 候補：作成ロジック / バリデーション / リポジトリ作成
- Vueコンポーネント（`app/assets/javascripts/snippets/`）を直接確認していない
  - 候補：フォーム構造 / バリデーション / API呼び出し

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: 共有パーシャル - 直接確認済み
- 0: モデル定義 - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: GraphQL Mutation - 間接的な推測含む
- 1: サービスクラス - 間接的な推測含む
- 1: Vueコンポーネント - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] GraphQL Mutation `snippetCreate` の実装を確認
- [ ] Snippets::CreateService の作成ロジックを確認
- [ ] Vueコンポーネント `#js-snippet-edit` の実装を確認
- [ ] snippets_selected_visibility_level ヘルパーの動作を確認
- [ ] スパム検知・reCAPTCHA の実装を確認
