---
generated_at: 2026-01-22 11:25:00
metrics:
  claims_total: 26
  claims_with_evidence: 24
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：14-マージリクエスト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：24 / 26、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIの詳細仕様**：APIスキーマの確認が必要
  2. **Vue.jsアプリケーションの詳細仕様**：フロントエンドコードの詳細解析が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/dashboard/merge_requests.html.haml`
- E-02: `app/controllers/dashboard_controller.rb`
- E-03: `config/routes/dashboard.rb`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/dashboard/merge_requests` である | E-03 (Line 7) | ○ |
| C-02 | コントローラは DashboardController である | E-02 | ○ |
| C-03 | ビューファイルは merge_requests.html.haml である | E-01 | ○ |
| C-04 | ページタイトルは "Merge requests" である | E-01 (Line 2-3) | ○ |
| C-05 | search_merge_requestsアクションが存在する | E-02 (Line 58-60), E-03 (Line 10) | ○ |
| C-06 | mergedルートが存在する | E-03 (Line 11) | ○ |
| C-07 | followingルートが存在する | E-03 (Line 9) | ○ |
| C-08 | クエリストリングがある場合searchへリダイレクト | E-02 (Line 17-21) | ○ |
| C-09 | show_mr_dashboard_banner?による条件分岐がある | E-01 (Line 13) | ○ |
| C-10 | Vue.jsアプリケーションがマウントされる | E-01 (Line 32-38) | ○ |
| C-11 | merge_request_dashboard_dataがアプリデータとして渡される | E-01 (Line 35) | ○ |
| C-12 | list_typeがユーザー設定から取得される | E-01 (Line 36) | ○ |
| C-13 | show_drafts設定が渡される | E-01 (Line 37) | ○ |
| C-14 | 画面番号は14である | E-04 | ○ |
| C-15 | カテゴリはダッシュボードである | E-04 | ○ |
| C-16 | 関連機能はTodoリスト(124)である | E-05 | ○ |
| C-17 | 関連機能にマージリクエスト作成(28)がある | E-05 | ○ |
| C-18 | feature_categoryはcode_review_workflowである | E-02 (Line 32) | ○ |
| C-19 | urgencyはlowである | E-02 (Line 34) | ○ |
| C-20 | SAML再認証通知が表示される可能性がある | E-01 (Line 10-11) | ○ |
| C-21 | gl_tabsによるタブナビゲーションがある | E-01 (Line 41-44) | ○ |
| C-22 | search_timeoutの処理がある | E-01 (Line 59-60) | ○ |
| C-23 | no_filters_setの処理がある | E-01 (Line 57-58) | ○ |
| C-24 | #js-merge-request-dashboard-configが存在する | E-01 (Line 27) | ○ |
| C-25 | GraphQL APIの詳細なスキーマ | **根拠なし** | △ |
| C-26 | Vue.jsアプリケーションの詳細な動作仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **GraphQL APIスキーマの詳細**
  - 候補：`app/graphql/` / GraphQL schema files
- **Vue.jsフロントエンドコードの詳細解析**
  - 候補：`app/assets/javascripts/merge_requests/` / `ee/app/assets/javascripts/`
- **merge_request_dashboard_dataヘルパーの実装**
  - 候補：`app/helpers/` 配下

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 基本的な画面構成とルーティングは明確
- **1: 中リスク** - フロントエンド（Vue.js）部分の詳細仕様は要確認
- **1: 中リスク** - 新旧MRダッシュボードの切り替えロジックは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/dashboard/merge_requests` が正しいか確認
- [ ] Vue.jsアプリケーションのマウントポイント `#js-merge-request-dashboard` が実際に存在するか確認
- [ ] タブ切り替え（Active/Merged/Search）の動作確認
- [ ] 新MRダッシュボードバナーの表示条件確認
