---
generated_at: 2026-01-22 12:02:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：140-スニペット編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **Vueコンポーネント詳細**：フロントエンドコード未確認
  2. **スパム検出処理**：reCAPTCHA実装詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/projects/snippets/edit.html.haml`（行1-7）
- E-02: `app/controllers/projects/snippets_controller.rb`（行1-53）
- E-03: `app/views/shared/snippets/_form.html.haml`（行1-2）
- E-04: `app/models/snippet.rb`（モデル定義、バリデーション）
- E-05: `app/graphql/mutations/snippets/update.rb`（行1-86）
- E-06: `app/services/snippets/update_service.rb`（行1-152）
- E-07: `config/routes/project.rb`（行433-438、ルーティング定義）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行193）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パンくずリストにSnippets、参照番号、Editを表示 | E-01 | ○ |
| C-02 | ページタイトルは「Edit」「スニペットタイトル（参照番号）」 | E-01 | ○ |
| C-03 | PageHeadingComponentで「Edit snippet」見出し表示 | E-01 | ○ |
| C-04 | shared/snippets/_formパーシャルを使用 | E-01 | ○ |
| C-05 | authorize_read_snippet!で閲覧権限チェック | E-02 | ○ |
| C-06 | authorize_update_snippet!で編集権限チェック | E-02 | ○ |
| C-07 | snippetメソッドでスニペット取得（before_action） | E-02 | ○ |
| C-08 | Vueコンポーネント `#js-snippet-edit` をマウント | E-03 | ○ |
| C-09 | data属性で project_path を渡す | E-03 | ○ |
| C-10 | data属性で snippet-gid を渡す（Global ID） | E-03 | ○ |
| C-11 | data属性で visibility_levels を渡す | E-03 | ○ |
| C-12 | data属性で selected_level を渡す（現在値） | E-03 | ○ |
| C-13 | MAX_FILE_COUNT = 10 でファイル数制限 | E-04 | ○ |
| C-14 | DESCRIPTION_LENGTH_MAX = 1.megabyte | E-04 | ○ |
| C-15 | GraphQL Mutation UpdateSnippet による更新 | E-05 | ○ |
| C-16 | Mutation引数: id, title, description, visibility_level, blob_actions | E-05 | ○ |
| C-17 | Snippets::UpdateService による処理 | E-05, E-06 | ○ |
| C-18 | visibility_changed?で可視性変更チェック | E-06 | ○ |
| C-19 | COMMITTABLE_ATTRIBUTES = %w[file_name content] | E-06 | ○ |
| C-20 | URLパスは `/:namespace/:project/-/snippets/:id/edit` | E-07 | ○ |
| C-21 | Vueコンポーネントの内部フォーム構造 | **根拠なし** | △ |
| C-22 | スパム検出時のreCAPTCHA表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Vueコンポーネント（`app/assets/javascripts/snippets/`）を直接確認していない
  - 候補：フォーム構造 / GraphQL Query / 既存データ取得ロジック
- スパム検出・reCAPTCHAの実装詳細を直接確認していない
  - 候補：SpamProtection Concern / reCAPTCHA表示条件

## 5) リスクフラグ（レビュー観点）
- 0: ビューテンプレート - 直接確認済み
- 0: コントローラ定義 - 直接確認済み
- 0: 共有パーシャル - 直接確認済み
- 0: モデル定義 - 直接確認済み
- 0: GraphQL Mutation - 直接確認済み
- 0: サービスクラス - 直接確認済み
- 0: ルーティング定義 - 直接確認済み
- 1: Vueコンポーネント - 間接的な推測含む
- 1: スパム検出処理 - 間接的な推測含む

## 6) レビュアーチェックリスト（最小）
- [ ] Vueコンポーネント `#js-snippet-edit` の編集モード実装を確認
- [ ] GraphQL Query でスニペット既存データを取得するロジックを確認
- [ ] snippets_selected_visibility_level ヘルパーの動作を確認
- [ ] スパム検知・reCAPTCHA の実装を確認
- [ ] 可視性レベル変更時の権限チェックを確認
