---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：141-グループ詳細.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **トラッキングイベント詳細**：Snowplowイベントの実装詳細は推測を含む
  2. **招待バナー表示条件**：show_invite_banner?の詳細実装はEEに含まれる可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - showアクション定義（111-125行目）
- E-02: `app/views/groups/show.html.haml` - メインテンプレート
- E-03: `app/models/group.rb` - グループモデル定義
- E-04: `config/routes/group.rb` - ルーティング定義
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-07: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移図
- E-08: `app/models/group.rb` README_PROJECT_PATH定数（31行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ詳細画面はグループのトップページとして機能する | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}`である | E-04 | ○ |
| C-03 | HTML, Atom両フォーマットに対応している | E-01 (respond_to) | ○ |
| C-04 | インポート中はインポート画面へリダイレクトされる | E-01 (114-116行目) | ○ |
| C-05 | グループREADMEはgitlab-profileプロジェクトから取得される | E-03, E-08 | ○ |
| C-06 | 招待バナーはshow_invite_banner?で判定される | E-02 (7行目) | ○ |
| C-07 | Snowplowトラッキングでgroup_overviewイベントが送信される | E-01 (306行目) | ○ |
| C-08 | 画面種別は詳細である | E-05 | ○ |
| C-09 | 関連機能にグループ作成（No.9）が含まれる | E-06 | ○ |
| C-10 | アクティビティフィード機能（No.136）が補助機能である | E-06 | ○ |
| C-11 | グループ編集画面へ遷移可能である | E-07 | ○ |
| C-12 | メンバー一覧画面へ遷移可能である | E-07 | ○ |
| C-13 | GroupsControllerを使用する | E-01 | ○ |
| C-14 | before_actionでgroupメソッドが呼ばれる | E-01 (20行目) | ○ |
| C-15 | authorize_read_groupで権限チェックが行われる | E-01 | ○ |
| C-16 | GroupはNamespaceを継承している | E-03 (5行目) | ○ |
| C-17 | グループにはmilestones関連がある | E-03 (65行目) | ○ |
| C-18 | グループにはlabels関連がある | E-03 (100行目) | ○ |
| C-19 | 可視性レベルはpublic/internal/privateがある | E-03 | ○ |
| C-20 | グループにはavatarが設定可能である | E-03 (Avatarable include) | ○ |
| C-21 | 通知設定がユーザーごとに取得される | E-01 (360行目) | ○ |
| C-22 | groups_show_app_dataでVueアプリ用データが生成される | E-02 (26行目) | ○ |
| C-23 | Atomフォーマット時はload_eventsが呼ばれる | E-01 (311-313行目) | ○ |
| C-24 | EventCollectionでイベントが取得される | E-01 (348-350行目) | ○ |
| C-25 | セッションレス認証に対応している | E-01 (16-17行目) | ○ |
| C-26 | レイアウトはgroupが使用される | E-01 (335行目) | ○ |
| C-27 | トラッキングイベントの詳細パラメータ | **根拠不足** | △ |
| C-28 | 招待バナーの詳細表示条件 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- show_invite_banner?メソッドの詳細実装はヘルパーまたはEE機能に含まれる可能性がある
  - 候補：`app/helpers/groups_helper.rb` / `ee/app/helpers/groups_helper.rb`
- Snowplowトラッキングの詳細パラメータ仕様
  - 候補：Gitlab::Tracking実装 / Snowplow設定ファイル

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別、関連機能の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **1（中リスク）**: 権限制御の詳細（EE機能との連携部分）
- **1（中リスク）**: トラッキングイベントの仕様

## 6) レビュアーチェックリスト（最小）

- [ ] URL/ルーティングがconfig/routesと一致しているか確認
- [ ] 画面遷移図との整合性を確認
- [ ] 権限による表示制御がGroupPolicyと一致しているか確認
- [ ] 招待バナーの表示条件がEE機能を含む場合、その旨を追記検討
