---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：142-グループ新規作成.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **Mattermost連携の詳細条件**：chat_team作成の条件はEE機能に依存する可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - new/createアクション定義（77-109行目）
- E-02: `app/views/groups/new.html.haml` - メインテンプレート
- E-03: `app/models/group.rb` - グループモデル定義
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `app/controllers/groups_controller.rb` - authorize_create_group!（317-326行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ新規作成画面でグループを作成できる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/new`である | E-02 (page_title) | ○ |
| C-03 | GET/POSTの両HTTPメソッドに対応 | E-01 (new/create) | ○ |
| C-04 | 認証が必須である | E-01 (19行目) | ○ |
| C-05 | 親グループIDをクエリパラメータで指定できる | E-01 (78行目) | ○ |
| C-06 | Groups::CreateServiceでグループが作成される | E-01 (84-87行目) | ○ |
| C-07 | 作成成功時は新規グループ詳細画面へリダイレクト | E-01 (105行目) | ○ |
| C-08 | エラー時はフォームが再表示される | E-01 (107行目) | ○ |
| C-09 | 成功メッセージが表示される | E-01 (93-103行目) | ○ |
| C-10 | namespace_settingsが初期化される | E-01 (80行目) | ○ |
| C-11 | 画面種別は登録である | E-04 | ○ |
| C-12 | 関連機能にグループ作成（No.9）が含まれる | E-05 | ○ |
| C-13 | サブグループ作成時は親への権限が必要 | E-06 (319-320行目) | ○ |
| C-14 | 通常グループ作成にはcreate_group権限が必要 | E-06 (322行目) | ○ |
| C-15 | レイアウトはdashboardが使用される | E-01 (330-331行目) | ○ |
| C-16 | インポートタブが存在する | E-02 (18-20行目) | ○ |
| C-17 | gitlab_ui_form_forでフォームが生成される | E-02 (15行目) | ○ |
| C-18 | organization_idがパラメータに含まれる | E-01 (86行目) | ○ |
| C-19 | グループにはname属性がある | E-03 (226-232行目) | ○ |
| C-20 | グループにはvisibility_level属性がある | E-03 | ○ |
| C-21 | post_create_hookが呼ばれる | E-03 (810-813行目) | ○ |
| C-22 | group_featureが作成される | E-03 (244行目) | ○ |
| C-23 | バリデーションエラー時はフォーム再表示 | E-01 (107行目) | ○ |
| C-24 | v-cloak属性でVue初期化前の表示を制御 | E-02 (13行目) | ○ |
| C-25 | Mattermost連携時の成功メッセージ | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- Mattermost連携（chat_team）の有効化条件と詳細実装
  - 候補：`ee/app/services/groups/create_service.rb` / Mattermost設定

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別、フォーム項目の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: 権限チェックの実装
- **1（中リスク）**: EE機能（Mattermost連携）の条件

## 6) レビュアーチェックリスト（最小）

- [ ] フォーム項目がビューファイルと一致しているか確認
- [ ] バリデーションルールがモデルと一致しているか確認
- [ ] 権限チェックがポリシーファイルと整合しているか確認
- [ ] Mattermost連携の記述がEE機能として適切か確認
