---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：143-グループ編集.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **EE機能の詳細設定項目**：AI設定、MR承認設定の具体的な項目はEEファイル参照が必要
  2. **コンプライアンスフレームワーク設定**：EE専用機能の詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups_controller.rb` - edit/update/destroy/transferアクション
- E-02: `app/views/groups/edit.html.haml` - メインテンプレート
- E-03: `app/models/group.rb` - グループモデル
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `app/controllers/groups_controller.rb` - authorize_admin_group!（23行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ編集画面で設定変更ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/edit`である | E-02 | ○ |
| C-03 | GET/PATCH/PUTに対応 | E-01 | ○ |
| C-04 | authorize_admin_group!で権限チェック | E-06 | ○ |
| C-05 | SettingsBlockComponentでセクション表示 | E-02 (11-14行目) | ○ |
| C-06 | Groups::UpdateServiceで更新処理 | E-01 (157行目) | ○ |
| C-07 | 成功時はアンカー付きでリダイレクト | E-01 (172-178行目) | ○ |
| C-08 | namespace_settingsエラー時はアラート表示 | E-01 (159-161行目) | ○ |
| C-09 | レイアウトはgroup_settingsが使用される | E-01 (332-333行目) | ○ |
| C-10 | 画面種別は編集である | E-04 | ○ |
| C-11 | 関連機能にグループ編集（No.10）が含まれる | E-05 | ○ |
| C-12 | グループ削除はdestroyアクションで処理 | E-01 (180-219行目) | ○ |
| C-13 | Groups::MarkForDeletionServiceで削除スケジュール | E-01 (190行目) | ○ |
| C-14 | 即座削除は管理者のみ可能 | E-01 (185行目) | ○ |
| C-15 | グループ移行はtransferアクションで処理 | E-01 (234-246行目) | ○ |
| C-16 | Groups::TransferServiceで移行処理 | E-01 (237行目) | ○ |
| C-17 | エクスポートはexportアクションで処理 | E-01 (249-261行目) | ○ |
| C-18 | レート制限チェックが行われる | E-01 (371-376行目) | ○ |
| C-19 | 復元はrestoreアクションで処理 | E-01 (221-231行目) | ○ |
| C-20 | can?(:admin_group)でセクション表示判定 | E-02 (10, 36, 49行目) | ○ |
| C-21 | manage_merge_request_settings権限でMR設定表示 | E-02 (32行目) | ○ |
| C-22 | admin_compliance_framework権限でコンプライアンス表示 | E-02 (46行目) | ○ |
| C-23 | expanded_by_default?でセクション展開状態決定 | E-02 (3, 24行目) | ○ |
| C-24 | バッジAPIエンドポイントが設定される | E-01 (151行目) | ○ |
| C-25 | render_if_existsでEE機能を条件表示 | E-02 (30, 33-34行目) | ○ |
| C-26 | remove_group権限で削除セクション表示 | E-02 (63行目) | ○ |
| C-27 | パス変更時はルートも更新される | E-03 (path_changed_hook) | ○ |
| C-28 | 2FA設定は親グループで許可時のみ設定可能 | E-03 (1377-1383行目) | ○ |
| C-29 | AI設定セクションの詳細項目 | **根拠不足** | △ |
| C-30 | コンプライアンスフレームワークの詳細項目 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- AI設定セクションの具体的な設定項目
  - 候補：`ee/app/views/groups/settings/ai/_ai_settings.html.haml`
- コンプライアンスフレームワーク設定の詳細
  - 候補：`ee/app/views/groups/_compliance_frameworks.html.haml`
- MR承認設定の詳細項目
  - 候補：`ee/app/views/groups/settings/merge_requests/`

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **1（中リスク）**: 権限制御の詳細（複数の権限チェック）
- **1（中リスク）**: EE機能セクションの詳細
- **1（中リスク）**: 削除処理のフロー（スケジュール削除と即座削除）

## 6) レビュアーチェックリスト（最小）

- [ ] 各設定セクションの権限チェックがポリシーと一致しているか確認
- [ ] 削除処理のフロー（スケジュール削除）が正しいか確認
- [ ] EE機能セクションの表示条件を確認
- [ ] グループ移行の前提条件を確認
