---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：144-グループメンバー一覧.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **LDAP同期機能の詳細**：EE機能のためCE版では利用不可

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/group_members_controller.rb` - indexアクション定義
- E-02: `app/views/groups/group_members/index.html.haml` - メインテンプレート
- E-03: `app/models/group_member.rb` - グループメンバーモデル（存在確認のみ）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング
- E-06: `app/controllers/groups/group_members_controller.rb` - MEMBER_PER_PAGE_LIMIT定数（10行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループメンバー一覧画面でメンバー管理ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/group_members`である | E-02 | ○ |
| C-03 | ページネーションは50件単位 | E-06 | ○ |
| C-04 | authorize_read_group_member!で閲覧権限チェック | E-01 (18行目) | ○ |
| C-05 | authorize_admin_group_member!で管理権限チェック | E-01 (17行目) | ○ |
| C-06 | デフォルトソートはname_asc | E-01 (28行目) | ○ |
| C-07 | GroupMembersFinderでメンバー取得 | E-01 (55-57行目) | ○ |
| C-08 | AccessRequestsFinderでリクエスト取得 | E-01 (44-46行目) | ○ |
| C-09 | 画面種別は一覧である | E-04 | ○ |
| C-10 | 関連機能にグループメンバー管理（No.85）が含まれる | E-05 | ○ |
| C-11 | 招待機能（No.86）が補助機能である | E-05 | ○ |
| C-12 | admin権限時は招待中メンバーも表示 | E-01 (31-39行目) | ○ |
| C-13 | include_relationsで継承メンバー表示制御 | E-01 (29行目) | ○ |
| C-14 | Vueコンポーネントでメンバーリスト表示 | E-02 (30行目) | ○ |
| C-15 | group_members_app_dataでVueデータ生成 | E-02 (30-39行目) | ○ |
| C-16 | グループ招待モーダルが表示される | E-02 (26行目) | ○ |
| C-17 | create_group_link権限でグループ招待ボタン表示 | E-02 (15-17行目) | ○ |
| C-18 | can_invite_group_member?で招待ボタン表示 | E-02 (20-23行目) | ○ |
| C-19 | PageHeadingComponentでヘッダー表示 | E-02 (8行目) | ○ |
| C-20 | メンバーガイドラインが表示される | E-02 (11-13行目) | ○ |
| C-21 | search_invitedで招待メール検索 | E-01 (34-35行目) | ○ |
| C-22 | placeholder_users_countでインポートユーザー数取得 | E-01 (42, 108-116行目) | ○ |
| C-23 | Import::SourceUsersFinderで取得 | E-01 (119-120行目) | ○ |
| C-24 | membershipable メソッドでgroupを返す | E-01 (50行目) | ○ |
| C-25 | filter_paramsでフィルタパラメータ取得 | E-01 (80-82行目) | ○ |
| C-26 | present_membersでプレゼンター適用 | E-01 (41, 44行目) | ○ |
| C-27 | 招待メンバーはinviteスコープで取得 | E-01 (61行目) | ○ |
| C-28 | LDAP同期機能の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- LDAP同期機能の詳細実装
  - 候補：`ee/app/views/groups/group_members/_ldap_sync.html.haml`
- ブロックメンバー機能の詳細
  - 候補：`ee/app/controllers/groups/group_members_controller.rb`

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フィルタ・検索・ソート機能
- **1（中リスク）**: EE機能（LDAP同期、ブロックメンバー）

## 6) レビュアーチェックリスト（最小）

- [ ] Vueコンポーネントのデータ形式を確認
- [ ] ページネーション件数がUIと一致しているか確認
- [ ] 権限チェックがポリシーファイルと整合しているか確認
- [ ] EE機能の記述が適切か確認
