---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：145-ラベル一覧.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **ラベルプロモート機能**：グループラベルへの昇格機能の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/labels_controller.rb` - indexアクション定義
- E-02: `app/views/groups/labels/index.html.haml` - メインテンプレート
- E-03: `app/models/label.rb` - ラベルモデル
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループラベル一覧画面でラベル管理ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/labels`である | E-02 | ○ |
| C-03 | HTML, JSON両フォーマットに対応 | E-01 (21-31行目) | ○ |
| C-04 | LabelsFinder でラベル取得 | E-01 (128-144行目) | ○ |
| C-05 | only_group_labels: trueでグループラベルのみ | E-01 (137行目) | ○ |
| C-06 | include_ancestor_groups: trueで継承ラベル含む | E-01 (138行目) | ○ |
| C-07 | LabelsPreloaderでプリロード | E-01 (26行目) | ○ |
| C-08 | 画面種別は一覧である | E-04 | ○ |
| C-09 | 関連機能にラベル管理（No.40）が含まれる | E-05 | ○ |
| C-10 | authorize_group_for_admin_labels!で権限チェック | E-01 (7行目) | ○ |
| C-11 | ToggleSubscriptionAction concernを使用 | E-01 (4行目) | ○ |
| C-12 | labels_archiveフラグで機能制御 | E-01 (11-13行目) | ○ |
| C-13 | CrudComponentでラベル一覧表示 | E-02 (24行目) | ○ |
| C-14 | デフォルトソートはname_asc | E-01 (148行目) | ○ |
| C-15 | 検索パラメータに対応 | E-01 (142行目) | ○ |
| C-16 | 購読フィルタに対応 | E-01 (140行目) | ○ |
| C-17 | アーカイブフィルタに対応 | E-01 (129-131, 143行目) | ○ |
| C-18 | destroyアクションでラベル削除 | E-01 (71-79行目) | ○ |
| C-19 | 削除成功時はリダイレクトとメッセージ表示 | E-01 (73-74行目) | ○ |
| C-20 | 削除失敗時はエラーメッセージ表示 | E-01 (76-77行目) | ○ |
| C-21 | lock_on_mergeラベルは削除不可 | E-03 (336-341行目) | ○ |
| C-22 | default_scopeでタイトル昇順ソート | E-03 (40行目) | ○ |
| C-23 | 検索結果なしメッセージが表示される | E-02 (31-32行目) | ○ |
| C-24 | 空状態が表示される | E-02 (40行目) | ○ |
| C-25 | 購読結果なしメッセージが表示される | E-02 (34-35行目) | ○ |
| C-26 | ラベルプロモート機能の詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- ラベルプロモート機能（プロジェクトラベルからグループラベルへの昇格）の詳細
  - 候補：`#js-promote-label-modal`のVueコンポーネント実装

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フィルタ・検索機能
- **1（中リスク）**: ラベルプロモート機能の詳細

## 6) レビュアーチェックリスト（最小）

- [ ] labels_archiveフラグの有効/無効状態を確認
- [ ] フィルタパラメータの動作を確認
- [ ] lock_on_merge ラベルの削除制限を確認
- [ ] ラベルプロモートモーダルの実装を確認
