---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：146-ラベル新規作成.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/labels_controller.rb` - new/createアクション定義
- E-02: `app/views/groups/labels/new.html.haml` - メインテンプレート
- E-03: `app/views/shared/labels/_form.html.haml` - 共有フォームパーシャル
- E-04: `app/services/labels/create_service.rb` - ラベル作成サービス
- E-05: `app/models/label.rb` - ラベルモデル
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループラベル新規作成画面でラベル作成ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/labels/new`である | E-02 (7行目) | ○ |
| C-03 | GET/POSTに対応 | E-01 (34-55行目) | ○ |
| C-04 | authorize_group_for_admin_labels!で権限チェック | E-01 (7行目) | ○ |
| C-05 | Labels::CreateServiceで作成処理 | E-01 (40行目) | ○ |
| C-06 | 成功時はgroup_labels_pathへリダイレクト | E-01 (45行目) | ○ |
| C-07 | 失敗時はnewテンプレートをレンダリング | E-01 (47行目) | ○ |
| C-08 | 画面種別は登録である | E-06 | ○ |
| C-09 | 関連機能にラベル管理（No.40）が含まれる | E-07 | ○ |
| C-10 | タイトルは必須入力 | E-03 (20行目, required: true) | ○ |
| C-11 | タイトルにautofocus設定 | E-03 (20行目) | ○ |
| C-12 | 説明はTextAreaで4行 | E-03 (26行目, rows: 4) | ○ |
| C-13 | カラーピッカーが表示される | E-03 (29-33行目) | ○ |
| C-14 | 推奨色が表示される | E-03 (36行目, render_suggested_colors) | ○ |
| C-15 | 新規作成時は「Create label」ボタン表示 | E-03 (49行目) | ○ |
| C-16 | キャンセルボタンでback_pathへ遷移 | E-03 (50-51行目) | ○ |
| C-17 | カラー名からHEXへ変換される | E-04 (11行目) | ○ |
| C-18 | group.labels.createで作成 | E-04 (18行目) | ○ |
| C-19 | タイトルはグループ内で一意 | E-05 (34行目) | ○ |
| C-20 | 説明は512KBが上限 | E-05 (14, 38行目) | ○ |
| C-21 | PageHeadingComponentでヘッダー表示 | E-02 (5行目) | ○ |
| C-22 | previous_labels_pathでリターンパス設定 | E-01 (36行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フォーム入力項目
- **0（低リスク）**: バリデーションルール

## 6) レビュアーチェックリスト（最小）

- [ ] タイトルの一意性制約がUIで適切にフィードバックされるか確認
- [ ] カラーピッカーの動作を確認
- [ ] 権限チェックがポリシーファイルと整合しているか確認
