---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：147-ラベル編集.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/labels_controller.rb` - edit/update/destroyアクション定義
- E-02: `app/views/groups/labels/edit.html.haml` - メインテンプレート
- E-03: `app/views/shared/labels/_form.html.haml` - 共有フォームパーシャル
- E-04: `app/models/label.rb` - ラベルモデル
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループラベル編集画面でラベル編集ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/labels/{id}/edit`である | E-02 | ○ |
| C-03 | GET/PATCH/PUT/DELETEに対応 | E-01 (57-79行目) | ○ |
| C-04 | authorize_group_for_admin_labels!で権限チェック | E-01 (7行目) | ○ |
| C-05 | authorize_label_for_admin_label!でラベル権限チェック | E-01 (8行目) | ○ |
| C-06 | labelメソッドで対象ラベル取得 | E-01 (6, 95-97行目) | ○ |
| C-07 | save_previous_label_pathでリターンパス保存 | E-01 (9, 124-126行目) | ○ |
| C-08 | Labels::UpdateServiceで更新処理 | E-01 (62行目) | ○ |
| C-09 | 成功時はredirect_back_or_group_labels_path | E-01 (65行目) | ○ |
| C-10 | 失敗時はeditテンプレートをレンダリング | E-01 (67行目) | ○ |
| C-11 | @label.destroyで削除実行 | E-01 (72行目) | ○ |
| C-12 | 削除成功時はラベル名付きメッセージ | E-01 (73-74行目) | ○ |
| C-13 | 削除失敗時はエラーメッセージ表示 | E-01 (76-77行目) | ○ |
| C-14 | 画面種別は編集である | E-05 | ○ |
| C-15 | 関連機能にラベル管理（No.40）が含まれる | E-06 | ○ |
| C-16 | supports_lock_on_merge?でロック設定表示判定 | E-02 (5行目) | ○ |
| C-17 | PageHeadingComponentでヘッダー表示 | E-02 (7行目) | ○ |
| C-18 | アーカイブ警告が表示される | E-03 (5-8行目) | ○ |
| C-19 | アーカイブ解除ボタンが表示される | E-03 (10-12行目) | ○ |
| C-20 | lock_on_mergeチェックボックスが表示される | E-03 (37-43行目) | ○ |
| C-21 | ロック済みラベルはチェックボックスがdisabled | E-03 (43行目) | ○ |
| C-22 | 編集時は「Save changes」ボタン表示 | E-03 (47行目) | ○ |
| C-23 | 削除ボタンが表示される | E-03 (53-56行目) | ○ |
| C-24 | prevent_locked_label_destroyでロックラベル削除防止 | E-04 (28行目) | ○ |
| C-25 | タイトルはグループ内で一意 | E-04 (34行目) | ○ |
| C-26 | label_paramsでarchived許可はフラグ有効時 | E-01 (106行目) | ○ |
| C-27 | label_paramsでlock_on_merge許可はsupports時 | E-01 (107行目) | ○ |
| C-28 | previous_labels_pathはセッションから取得 | E-01 (116-118行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フォーム入力項目
- **0（低リスク）**: ロック機能の動作

## 6) レビュアーチェックリスト（最小）

- [ ] lock_on_mergeの無効化ができないことを確認
- [ ] ロックラベル削除時のエラーメッセージを確認
- [ ] アーカイブ警告の表示条件を確認
- [ ] リターンパス（セッション）の動作を確認
