---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：148-マイルストーン一覧.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/milestones_controller.rb` - indexアクション定義
- E-02: `app/views/groups/milestones/index.html.haml` - メインテンプレート
- E-03: `app/models/milestone.rb` - マイルストーンモデル
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループマイルストーン一覧画面でマイルストーン管理ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/milestones`である | E-02 | ○ |
| C-03 | HTML, JSON両フォーマットに対応 | E-01 (13-21行目) | ○ |
| C-04 | Milestone.states_countで状態別カウント取得 | E-01 (15行目) | ○ |
| C-05 | MilestonesFinder.executeでマイルストーン取得 | E-01 (109-111行目) | ○ |
| C-06 | デフォルトソートはdue_date_asc | E-01 (122行目) | ○ |
| C-07 | 状態フィルタに対応（state param） | E-01 (123行目) | ○ |
| C-08 | タイトル検索に対応（search_title param） | E-01 (123行目) | ○ |
| C-09 | 画面種別は一覧である | E-04 | ○ |
| C-10 | 関連機能にマイルストーン管理（No.42）が含まれる | E-05 | ○ |
| C-11 | admin_milestone権限で新規作成ボタン表示 | E-02 (13-15行目) | ○ |
| C-12 | 状態カウントチェックで一覧表示制御 | E-02 (6行目) | ○ |
| C-13 | milestones_filterで状態タブ表示 | E-02 (8行目) | ○ |
| C-14 | milestones/search_formで検索フォーム表示 | E-02 (11行目) | ○ |
| C-15 | milestones_sort_dropdownでソート選択 | E-02 (12行目) | ○ |
| C-16 | プロジェクト/グループでパーシャル分岐 | E-02 (26-29行目) | ○ |
| C-17 | paginate でページネーション | E-02 (30行目) | ○ |
| C-18 | 空状態表示（milestones empty state） | E-02 (32-35行目) | ○ |
| C-19 | タブ結果0件時の空状態表示（milestones_tab） | E-02 (17-20行目) | ○ |
| C-20 | state_machineで状態管理（active/closed） | E-03 (93-100行目) | ○ |
| C-21 | group_idsでグループフィルタ | E-01 (120, 130-136行目) | ○ |
| C-22 | project_idsでプロジェクトフィルタ | E-01 (123行目) | ○ |
| C-23 | JSON形式でid, title, due_date, nameを返す | E-01 (19行目) | ○ |
| C-24 | 削除モーダル（js-delete-milestone-modal） | E-02 (23行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フィルタ・検索・ソート機能
- **0（低リスク）**: 空状態の表示

## 6) レビュアーチェックリスト（最小）

- [ ] 状態フィルタの動作を確認（Active/Closed/All）
- [ ] ソート順の選択肢を確認
- [ ] ページネーション件数を確認
- [ ] プロジェクト/グループマイルストーンの表示分岐を確認
