---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：149-マイルストーン新規作成.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/milestones_controller.rb` - new/createアクション定義
- E-02: `app/views/groups/milestones/new.html.haml` - メインテンプレート
- E-03: `app/views/groups/milestones/_form.html.haml` - フォームパーシャル
- E-04: `app/services/milestones/create_service.rb` - マイルストーン作成サービス
- E-05: `app/models/milestone.rb` - マイルストーンモデル
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループマイルストーン新規作成画面でマイルストーン作成ができる | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/milestones/new`である | E-02 | ○ |
| C-03 | GET/POSTに対応 | E-01 (24-36行目) | ○ |
| C-04 | authorize_admin_milestones!で権限チェック | E-01 (7行目) | ○ |
| C-05 | Milestones::CreateServiceで作成処理 | E-01 (29行目) | ○ |
| C-06 | 成功時はmilestone_pathへリダイレクト | E-01 (32行目) | ○ |
| C-07 | 失敗時はnewテンプレートをレンダリング | E-01 (34行目) | ○ |
| C-08 | 画面種別は登録である | E-06 | ○ |
| C-09 | 関連機能にマイルストーン管理（No.42）が含まれる | E-07 | ○ |
| C-10 | タイトルは必須入力、255文字制限 | E-03 (9行目, maxlength: 255) | ○ |
| C-11 | タイトルにautofocus設定 | E-03 (9行目) | ○ |
| C-12 | 開始日・期限日入力欄がある | E-03 (10行目, _form_dates) | ○ |
| C-13 | 説明はMarkdownエディタ | E-03 (14-22行目, js-markdown-editor) | ○ |
| C-14 | 新規作成時は「Create milestone」ボタン表示 | E-03 (30行目) | ○ |
| C-15 | キャンセルボタンでgroup_milestones_pathへ遷移 | E-03 (31-32行目) | ○ |
| C-16 | @noteable = @milestoneで設定 | E-01 (25行目) | ○ |
| C-17 | parent.milestones.newでインスタンス生成 | E-04 (6行目) | ○ |
| C-18 | スパムチェックが実行される | E-04 (8, 20-22行目) | ○ |
| C-19 | execute_hooksでWebhook発火 | E-04 (12行目) | ○ |
| C-20 | タイトルはグループ内で一意 | E-05 (88行目) | ○ |
| C-21 | has_internal_idでIID採番 | E-05 (30行目) | ○ |
| C-22 | state初期値はactive | E-05 (93行目) | ○ |
| C-23 | PageHeadingComponentでヘッダー表示 | E-02 (5行目) | ○ |
| C-24 | lock_versionがhidden_fieldで設定 | E-03 (27行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: フォーム入力項目
- **0（低リスク）**: バリデーションルール

## 6) レビュアーチェックリスト（最小）

- [ ] タイトルの一意性制約がUIで適切にフィードバックされるか確認
- [ ] 開始日・期限日のバリデーションを確認
- [ ] Markdownエディタのプレビュー機能を確認
- [ ] スパムチェックの動作を確認
