---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：150-マイルストーン詳細.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **バーンダウンチャートの詳細**：EE機能のためCE版では利用不可

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/groups/milestones_controller.rb` - showアクション定義
- E-02: `app/views/groups/milestones/show.html.haml` - メインテンプレート
- E-03: `app/views/shared/milestones/_top.html.haml` - ヘッダーパーシャル
- E-04: `app/views/shared/milestones/_tabs.html.haml` - タブパーシャル
- E-05: `app/models/milestone.rb` - マイルストーンモデル
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループマイルストーン詳細画面でマイルストーン詳細が表示される | E-01, E-02 | ○ |
| C-02 | URLパスは`/groups/{group_path}/-/milestones/{iid}`である | E-02 | ○ |
| C-03 | milestoneメソッドでIIDで検索 | E-01 (113-117行目) | ○ |
| C-04 | find_by_iidで検索 | E-01 (114行目) | ○ |
| C-05 | render_404で不存在時404 | E-01 (116行目) | ○ |
| C-06 | 画面種別は詳細である | E-06 | ○ |
| C-07 | 関連機能にマイルストーン管理（No.42）が含まれる | E-07 | ○ |
| C-08 | _topパーシャルでヘッダー表示 | E-02 (3行目) | ○ |
| C-09 | _tabsパーシャルでタブ表示 | E-02 (4行目) | ○ |
| C-10 | _sidebarパーシャルでサイドバー表示 | E-02 (5行目) | ○ |
| C-11 | Work itemsタブが表示される | E-04 (9-11行目) | ○ |
| C-12 | MRタブはmerge_requests_enabled?で表示制御 | E-04 (12-15行目) | ○ |
| C-13 | Participantsタブが表示される | E-04 (16-18行目) | ○ |
| C-14 | Labelsタブが表示される | E-04 (19-21行目) | ○ |
| C-15 | タブにカウントバッジ表示 | E-04 (11, 15, 18, 21行目) | ○ |
| C-16 | タブはAjaxで遅延読み込み | E-04 (data: { endpoint: ... }) | ○ |
| C-17 | milestone_complete_alertで完了通知 | E-03 (6-8行目) | ○ |
| C-18 | グループマイルストーンは「You may close the milestone now.」表示 | E-03 (8行目) | ○ |
| C-19 | _headerパーシャルでステータス表示 | E-03 (10行目) | ○ |
| C-20 | _descriptionパーシャルで説明表示 | E-03 (12行目) | ○ |
| C-21 | バーンダウンチャートはrender_if_exists | E-03 (14行目) | ○ |
| C-22 | state_machineで状態管理 | E-05 (93-100行目) | ○ |
| C-23 | show_project_name: trueでプロジェクト名表示 | E-02 (4行目) | ○ |
| C-24 | _header_titleパーシャルでタイトル表示 | E-02 (2行目) | ○ |
| C-25 | affix_offsetでサイドバー固定位置設定 | E-02 (5行目) | ○ |
| C-26 | バーンダウンチャートの詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）

- バーンダウンチャートの詳細実装
  - 候補：`ee/app/views/shared/milestones/_burndown.html.haml`
- サイドバーの詳細実装
  - 候補：`app/views/shared/milestones/_sidebar.html.haml`

## 5) リスクフラグ（レビュー観点）

- **0（低リスク）**: 基本的なURL、画面種別の記載
- **0（低リスク）**: コントローラーアクションの処理フロー
- **0（低リスク）**: タブ構成と遅延読み込み
- **1（中リスク）**: EE機能（バーンダウンチャート）

## 6) レビュアーチェックリスト（最小）

- [ ] タブの遅延読み込みが正しく動作するか確認
- [ ] 各タブのカウントが正確に表示されるか確認
- [ ] 全課題完了時のアラートが表示されるか確認
- [ ] EE機能（バーンダウンチャート）の表示条件を確認
