---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：151-マイルストーン編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **タイトル最大長255文字**：コントローラーのmilestone_paramsにmaxlength指定がないため要確認
  2. **Maintainer以上のロール**：権限マッピングの明確な根拠なし
  3. **グループ階層内でタイトル一意**：モデルのバリデーションロジック確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/milestones/edit.html.haml`（行1-7）
- E-02: `app/views/groups/milestones/_form.html.haml`（行1-37）
- E-03: `app/controllers/groups/milestones_controller.rb`（行1-140）
- E-04: `app/services/milestones/update_service.rb`（行1-42）
- E-05: `app/models/milestone.rb`（行1-341）
- E-06: `config/routes/group.rb`（行109-116）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行208）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/milestones/:id/edit` | E-06 | ○ |
| C-02 | edit/updateアクションが存在する | E-03 行40,42 | ○ |
| C-03 | admin_milestone権限が必要 | E-03 行7,93-95 | ○ |
| C-04 | タイトルは必須項目 | E-02 行9, E-05 行85 | ○ |
| C-05 | タイトル最大長255文字 | E-02 行9 (maxlength属性) | ○ |
| C-06 | 説明はMarkdown形式 | E-02 行14-22 | ○ |
| C-07 | lock_versionで楽観的ロック | E-02 行27, E-03 行62-79 | ○ |
| C-08 | Milestones::UpdateServiceを使用 | E-03 行43 | ○ |
| C-09 | 更新成功時は詳細画面にリダイレクト | E-03 行48 | ○ |
| C-10 | StaleObjectError時はコンフリクト表示 | E-03 行62-79 | ○ |
| C-11 | milestonesテーブルを更新 | E-04, E-05 | ○ |
| C-12 | MilestoneUpdatedEventを発行 | E-04 行28-37 | ○ |
| C-13 | スパムチェックを実行 | E-04 行24-26, E-05 行297-299 | ○ |
| C-14 | パンくずリストに「Edit」表示 | E-01 行1 | ○ |
| C-15 | 機能No.41（マイルストーン管理）に関連 | E-07 | ○ |
| C-16 | タイトル重複時にエラー | E-05 行330-339 | ○ |
| C-17 | iidでマイルストーンを検索 | E-03 行114 | ○ |
| C-18 | Maintainer以上のロールが必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18について：`can?(current_user, :admin_milestone, group)`の権限チェックは確認できるが、具体的にどのロールが該当するかはPolicyファイルを確認する必要がある
  - 候補：`app/policies/group_policy.rb` / `ee/app/policies/ee/group_policy.rb` / GitLab公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なフォーム処理であり、コードベースで十分に確認可能
- 1: 中リスク - タイトル一意性のバリデーションロジックが複雑（グループ階層を考慮）

## 6) レビュアーチェックリスト（最小）
- [ ] admin_milestone権限の具体的なロール要件を確認
- [ ] タイトル一意性チェックの範囲（グループ階層内）が要件と一致するか確認
- [ ] 楽観的ロック競合時のUXが適切か確認
- [ ] Markdownエディタの機能（プレビュー、クイックアクション）が正しく動作するか確認
