---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：152-ボード一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ボード削除確認メッセージ**：フロントエンド実装の確認が必要
  2. **デフォルトボード自動作成**：Finderの実装詳細確認推奨
  3. **ライセンスによる複数ボード制限**：EE機能の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/boards/index.html.haml`（行1）
- E-02: `app/views/shared/boards/_show.html.haml`（行1-23）
- E-03: `app/controllers/groups/boards_controller.rb`（行1-36）
- E-04: `app/helpers/boards_helper.rb`（行1-121）
- E-05: `config/routes/group.rb`（行154）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行209）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/boards` | E-05 | ○ |
| C-02 | BoardsActionsをinclude | E-03 行4 | ○ |
| C-03 | read_issue_board権限でアクセス制御 | E-03 行30-32 | ○ |
| C-04 | Boards::BoardsFinderを使用 | E-03 行20-23 | ○ |
| C-05 | 共有テンプレートを使用 | E-01 行1 | ○ |
| C-06 | Vue.jsアプリケーションにマウント | E-02 行22 | ○ |
| C-07 | board_dataヘルパーを使用 | E-02 行22, E-04 行8-30 | ○ |
| C-08 | multiple_issue_boards_available?で制限 | E-04 行90-92 | ○ |
| C-09 | ページタイトル「Issue Boards」 | E-02 行7 | ○ |
| C-10 | admin_issue_board権限で編集制御 | E-04 行115-117 | ○ |
| C-11 | 機能No.39（イシューボード）に関連 | E-06 | ○ |
| C-12 | work_items_dataをboard_dataに含む | E-04 行28 | ○ |
| C-13 | フィーチャーフラグを設定 | E-03 行8-13 | ○ |
| C-14 | Boards::CreateServiceを使用 | E-03 行25-28 | ○ |
| C-15 | ボード削除確認メッセージ表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15について：ボード削除時の確認メッセージはフロントエンド（Vue.js）側で実装されており、バックエンドのコードからは確認できない
  - 候補：`app/assets/javascripts/boards/` / `ee/app/assets/javascripts/boards/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示機能であり、データ変更リスクが低い
- 1: 中リスク - 複数ボードのライセンス制限はEE機能であり、CE環境での動作確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] ボード一覧が正しく表示されることを確認
- [ ] 権限に応じた操作ボタンの表示/非表示を確認
- [ ] 複数ボード機能のライセンス制限が正しく動作するか確認
