---
generated_at: 2026-01-22 12:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：153-ボード表示

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **ドラッグ&ドロップによるラベル更新**：フロントエンド実装の確認必要
  2. **リスト削除確認メッセージ**：フロントエンド実装の確認必要
  3. **ポジショニング無効化設定**：設定の影響範囲確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/boards/show.html.haml`（行1）
- E-02: `app/views/shared/boards/_show.html.haml`（行1-23）
- E-03: `app/controllers/groups/boards_controller.rb`（行1-36）
- E-04: `app/helpers/boards_helper.rb`（行1-121）
- E-05: `config/routes/group.rb`（行154）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行210）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/boards/:id` | E-05 | ○ |
| C-02 | group: trueオプションで共有テンプレート使用 | E-01 行1 | ○ |
| C-03 | #js-issuable-board-appにVueマウント | E-02 行22 | ○ |
| C-04 | 右サイドバーポータル設定 | E-02 行15-16 | ○ |
| C-05 | board_dataでVueアプリにデータ渡す | E-02 行22, E-04 行8-30 | ○ |
| C-06 | time_tracking_limit_to_hours設定を適用 | E-04 行17 | ○ |
| C-07 | can_update?で課題更新権限チェック | E-04 行107-109 | ○ |
| C-08 | can_admin_list?でリスト管理権限チェック | E-04 行111-113 | ○ |
| C-09 | ページタイトルにボード名含む | E-02 行18 | ○ |
| C-10 | Issue Boardsと表示 | E-02 行6-7 | ○ |
| C-11 | 機能No.39（イシューボード）に関連 | E-06 | ○ |
| C-12 | labels_fetch_pathでラベル取得 | E-04 行58-64 | ○ |
| C-13 | releases_fetch_pathでリリース取得 | E-04 行74-80 | ○ |
| C-14 | build_issue_link_baseでリンクベース生成 | E-04 行50-56 | ○ |
| C-15 | D&Dでラベル更新 | **根拠なし** | △ |
| C-16 | リスト削除確認メッセージ表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15, C-16について：ドラッグ&ドロップや確認メッセージはフロントエンド（Vue.js）側で実装されており、バックエンドのコードからは確認できない
  - 候補：`app/assets/javascripts/boards/` / `ee/app/assets/javascripts/boards/` / GraphQL API

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ドラッグ&ドロップ操作はデータベース更新を伴うため、動作確認必要
- 1: 中リスク - グループ配下の複数プロジェクトの課題を扱うため、パフォーマンス確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ドラッグ&ドロップによる課題移動が正しく動作することを確認
- [ ] 権限に応じたリスト操作の制限を確認
- [ ] グループ配下の全プロジェクトの課題が正しく表示されることを確認
- [ ] フィルター機能が正しく動作することを確認
- [ ] 右サイドバーで課題詳細が正しく表示されることを確認
