---
generated_at: 2026-01-22 12:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：154-作業アイテム一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **create_work_item権限**：権限チェックの実装詳細確認推奨
  2. **GraphQL API**：フロントエンド実装の確認必要
  3. **WorkItemsCollections**：Concernの詳細実装確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/work_items/index.html.haml`（行1-6）
- E-02: `app/controllers/groups/work_items_controller.rb`（行1-76）
- E-03: `app/helpers/work_items_helper.rb`（行1-162）
- E-04: `config/routes/group.rb`（行39-40, 193）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行211）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/work_items` | E-04 行193 | ○ |
| C-02 | RSS/ICSフィード対応 | E-04 行39-40, E-02 行38-56 | ○ |
| C-03 | ページタイトル「Work items」 | E-01 行1 | ○ |
| C-04 | #js-work-itemsにVueマウント | E-01 行6 | ○ |
| C-05 | work_item_views_only_dataを使用 | E-01 行6, E-03 行18-20 | ○ |
| C-06 | 検索レート制限チェック | E-02 行20-22 | ○ |
| C-07 | フィーチャーフラグを設定 | E-02 行10-17 | ○ |
| C-08 | work_item_planning_viewフラグ | E-02 行13-14 | ○ |
| C-09 | work_items_saved_viewsフラグ | E-02 行15 | ○ |
| C-10 | use_work_item_urlフラグ | E-02 行16 | ○ |
| C-11 | indexアクションはビューのみ | E-02 行29 | ○ |
| C-12 | 機能No.46（ワークアイテム管理）に関連 | E-05 | ○ |
| C-13 | デザイン管理用スタイルシート | E-01 行4 | ○ |
| C-14 | create_work_item権限で作成制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14について：`create_work_item`権限のチェックはフロントエンド（Vue.js）またはGraphQL API側で実装されている可能性がある
  - 候補：`app/assets/javascripts/work_items/` / GraphQL mutations / `app/policies/work_item_policy.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示機能であり、データ変更リスクが低い
- 1: 中リスク - Work Items機能は比較的新しく、フィーチャーフラグによる制御が多い

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] 作業アイテム一覧が正しく表示されることを確認
- [ ] フィルター・ソート機能が正しく動作することを確認
- [ ] RSS/ICSフィードが正しく生成されることを確認
- [ ] フィーチャーフラグによる機能の有効/無効を確認
