---
generated_at: 2026-01-22 12:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：155-作業アイテム詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIによるデータ更新**：フロントエンド実装の確認必要
  2. **子アイテム追加の動作**：GraphQL mutationの確認必要
  3. **supports_work_items?メソッド**：グループモデルでの実装確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/work_items/show.html.haml`（行1-12）
- E-02: `app/controllers/groups/work_items_controller.rb`（行1-76）
- E-03: `app/helpers/work_items_helper.rb`（行1-162）
- E-04: `config/routes/group.rb`（行193）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行212）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/work_items/:iid` | E-04 | ○ |
| C-02 | /newで新規作成モード | E-02 行61-67 | ○ |
| C-03 | 右サイドバー無効化 | E-01 行2 | ○ |
| C-04 | GFMフォーム有効化 | E-01 行9 | ○ |
| C-05 | noteable_type='WorkItem' | E-01 行10 | ○ |
| C-06 | #js-work-itemsにVueマウント | E-01 行12 | ○ |
| C-07 | supports_work_items?チェック | E-02 行32 | ○ |
| C-08 | WorkItemsFinderで検索 | E-02 行34-35 | ○ |
| C-09 | handle_new_work_item_pathで新規処理 | E-02 行19, 61-67 | ○ |
| C-10 | 未認証時にauthenticate_user! | E-02 行64 | ○ |
| C-11 | work_item_views_only_dataを使用 | E-01 行12, E-03 行18-20 | ○ |
| C-12 | 機能No.46（ワークアイテム管理）に関連 | E-05 | ○ |
| C-13 | shared/work_item_metadataをレンダリング | E-01 行4 | ○ |
| C-14 | デザイン管理用スタイルシート | E-01 行8 | ○ |
| C-15 | GraphQL APIでデータ更新 | **根拠なし** | △ |
| C-16 | 子アイテム追加機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15, C-16について：データ更新や子アイテム追加はフロントエンド（Vue.js）とGraphQL APIで実装されており、バックエンドのビュー/コントローラーからは確認できない
  - 候補：`app/assets/javascripts/work_items/` / `app/graphql/mutations/work_items/` / GraphQL schema

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - データ更新機能があるため、権限チェックの確認が必要
- 1: 中リスク - 新規作成フローの認証チェックが正しく動作するか確認必要

## 6) レビュアーチェックリスト（最小）
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] 作業アイテムの詳細が正しく表示されることを確認
- [ ] 新規作成（/new）フローが正しく動作することを確認
- [ ] 未認証ユーザーが/newにアクセスした場合のリダイレクトを確認
- [ ] 存在しない作業アイテムへのアクセス時の404表示を確認
- [ ] グループがwork_itemsをサポートしていない場合の動作を確認
