---
generated_at: 2026-01-22 12:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：157-インフラレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  1. **なし** - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/infrastructure_registry/index.html.haml`（行1-5）
- E-02: `app/controllers/groups/infrastructure_registry_controller.rb`（行1-17）
- E-03: `config/routes/group.rb`（行106-107）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行214）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/terraform_module_registry` | E-03 行106 | ○ |
| C-02 | 旧パスは新パスにリダイレクト | E-03 行107 | ○ |
| C-03 | ページタイトル「Terraform Module Registry」 | E-01 行1 | ○ |
| C-04 | #js-vue-packages-listにVueマウント | E-01 行3 | ○ |
| C-05 | resource_idにグループIDを設定 | E-01 行3 | ○ |
| C-06 | page_typeは'groups' | E-01 行4 | ○ |
| C-07 | empty_list_illustrationを設定 | E-01 行5 | ○ |
| C-08 | verify_packages_enabled!でチェック | E-02 行5, 10-14 | ○ |
| C-09 | packages_feature_enabled?で判定 | E-02 行13 | ○ |
| C-10 | 機能No.62（パッケージレジストリ）に関連 | E-04 | ○ |
| C-11 | コントローラーはinherit Groups::ApplicationController | E-02 行4 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 一覧表示のみの機能であり、データ変更がない

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージ機能が無効な場合の404表示を確認
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] 旧URLからのリダイレクトが正しく動作することを確認
- [ ] Terraformモジュール一覧が正しく表示されることを確認
