---
generated_at: 2026-01-22 12:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：158-コンテナレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **イメージ削除機能**：削除処理の実装確認必要
  2. **メタデータデータベース**：GitLab API Clientの実装確認推奨
  3. **未完了タグクリーンアップコールアウト**：コールアウト表示条件確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/registry/repositories/index.html.haml`（行1-18）
- E-02: `app/controllers/groups/registry/repositories_controller.rb`（行1-51）
- E-03: `config/routes/group.rb`（行164）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行215）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/container_registries` | E-03 | ○ |
| C-02 | ページタイトル「Container registry」 | E-01 行1 | ○ |
| C-03 | GraphQL起動クエリを設定 | E-01 行2 | ○ |
| C-04 | #js-container-registryにVueマウント | E-01 行5 | ○ |
| C-05 | verify_container_registry_enabled!でチェック | E-02 行9, 41-42 | ○ |
| C-06 | authorize_read_container_image!で権限チェック | E-02 行10, 45-47 | ○ |
| C-07 | HTML/JSONフォーマット対応 | E-02 行16-31 | ○ |
| C-08 | ContainerRepositoriesFinderで検索 | E-02 行19-21 | ○ |
| C-09 | track_package_eventで追跡 | E-02 行23 | ○ |
| C-10 | is_adminフラグを設定 | E-01 行9 | ○ |
| C-11 | is_group_page: true | E-01 行10 | ○ |
| C-12 | registry_host_url_with_port設定 | E-01 行8 | ○ |
| C-13 | connection_errorフラグ設定 | E-01 行13 | ○ |
| C-14 | is_metadata_database_enabled設定 | E-01 行17 | ○ |
| C-15 | 機能No.63（コンテナレジストリ）に関連 | E-04 | ○ |
| C-16 | イメージ削除機能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16について：イメージ削除機能はAPI経由で実装されており、このコントローラーには削除アクションが含まれていない
  - 候補：`app/controllers/groups/registry/repositories_controller.rb`（別アクション）/ GraphQL mutations / REST API

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 外部レジストリサービスとの連携があり、接続エラーの可能性がある
- 0: 低リスク - 一覧表示機能としては標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] コンテナレジストリが無効な場合の404表示を確認
- [ ] read_container_image権限がないユーザーのアクセス制御を確認
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] GraphQL APIによるデータ取得が正しく動作することを確認
- [ ] 接続エラー時のエラー表示を確認
- [ ] JSON APIレスポンスのフォーマットを確認
