---
generated_at: 2026-01-22 12:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：159-Harbor連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **Harbor APIからのデータ取得**：外部API連携の実装確認必要
  2. **::Harbor::Repository Concern**：共通ロジックの詳細確認推奨
  3. **Harborインテグレーション有効性チェック**：親コントローラーの実装確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/harbor/repositories/index.html.haml`（行1-11）
- E-02: `app/controllers/groups/harbor/repositories_controller.rb`（行1-16）
- E-03: `config/routes/group.rb`（行167-173）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行216）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/harbor/repositories` | E-03 行168 | ○ |
| C-02 | ページタイトル「Harbor Registry」 | E-01 行1 | ○ |
| C-03 | #js-harbor-registry-list-groupにVueマウント | E-01 行3 | ○ |
| C-04 | ::Harbor::Repositoryをinclude | E-02 行6 | ○ |
| C-05 | containerメソッドで@groupを返す | E-02 行10-12 | ○ |
| C-06 | repository_urlにhostname設定 | E-01 行6 | ○ |
| C-07 | harbor_integration_project_name設定 | E-01 行7 | ○ |
| C-08 | full_path設定 | E-01 行8 | ○ |
| C-09 | connection_errorフラグ設定 | E-01 行9 | ○ |
| C-10 | invalid_path_errorフラグ設定 | E-01 行10 | ○ |
| C-11 | is_group_page: true | E-01 行11 | ○ |
| C-12 | 機能No.63（コンテナレジストリ）に関連 | E-04 | ○ |
| C-13 | Harbor APIからデータ取得 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13について：Harbor APIとの連携はフロントエンド（Vue.js）およびConcern内で実装されており、ビューテンプレートからは確認できない
  - 候補：`app/controllers/concerns/harbor/repository.rb` / `app/assets/javascripts/packages_and_registries/harbor_registry/`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 外部サービス（Harbor）との連携があり、接続エラーの可能性がある
- 0: 低リスク - 読み取り専用の機能であり、データ変更がない

## 6) レビュアーチェックリスト（最小）
- [ ] Harborインテグレーションが未設定の場合の動作を確認
- [ ] Harbor接続エラー時のエラー表示を確認
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] リポジトリ一覧が正しく表示されることを確認
- [ ] アーティファクト/タグ一覧への遷移が正しく動作することを確認
