---
generated_at: 2026-01-22 11:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-マイルストーン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/dashboard/milestones/index.html.haml`
- E-02: `app/controllers/dashboard/milestones_controller.rb`
- E-03: `app/finders/milestones_finder.rb`
- E-04: `app/models/milestone.rb`
- E-05: `config/routes/dashboard.rb`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは `/dashboard/milestones` である | E-05 (Line 14) | ○ |
| C-02 | コントローラは Dashboard::MilestonesController である | E-02 | ○ |
| C-03 | ビューファイルは index.html.haml である | E-01 | ○ |
| C-04 | ページタイトルは "Milestones" である | E-01 (Line 1) | ○ |
| C-05 | MilestonesFinderを使用してマイルストーンを取得する | E-02 (Line 24-26) | ○ |
| C-06 | before_action :projectsが実行される | E-02 (Line 4) | ○ |
| C-07 | before_action :groupsが実行される | E-02 (Line 5) | ○ |
| C-08 | feature_categoryはteam_planningである | E-02 (Line 7) | ○ |
| C-09 | urgencyはlowである | E-02 (Line 8) | ○ |
| C-10 | HTML/JSON両形式をサポートする | E-02 (Line 11-18) | ○ |
| C-11 | @milestone_statesで状態別カウントを取得する | E-02 (Line 13) | ○ |
| C-12 | ページネーションを使用する | E-02 (Line 14), E-01 (Line 26) | ○ |
| C-13 | 画面番号は16である | E-06 | ○ |
| C-14 | カテゴリはダッシュボードである | E-06 | ○ |
| C-15 | 関連機能はマイルストーン管理(41)である | E-07 | ○ |
| C-16 | state_machineで状態遷移が定義されている | E-04 (Line 93-105) | ○ |
| C-17 | for_projects_and_groupsスコープを使用する | E-03 (Line 65-70), E-04 (Line 62-70) | ○ |
| C-18 | PageHeadingComponentが使用されている | E-01 (Line 6) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、信頼性が高い
- **0: 低リスク** - サーバーサイドレンダリングによる従来型実装で理解しやすい

## 6) レビュアーチェックリスト（最小）
- [ ] URLパターン `/dashboard/milestones` が正しいか確認
- [ ] MilestonesFinderの検索条件が正確に記載されているか確認
- [ ] 状態フィルタ（Active/Closed）の動作確認
- [ ] ページネーションの動作確認
