---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：160-Dependency Proxy

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **キャッシュクリア機能**：APIエンドポイントの実装確認必要
  2. **DependencyProxy::GroupAccess Concern**：共通ロジックの詳細確認推奨
  3. **マニフェスト一覧取得API**：REST API実装の確認必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/views/groups/dependency_proxies/show.html.haml`（行1-8）
- E-02: `app/controllers/groups/dependency_proxies_controller.rb`（行1-24）
- E-03: `config/routes/group.rb`（行165）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行217）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面パスは`/groups/:group_id/-/dependency_proxy` | E-03 | ○ |
| C-02 | ページタイトル「Dependency Proxy」 | E-01 行1 | ○ |
| C-03 | #js-dependency-proxyにVueマウント | E-01 行3 | ○ |
| C-04 | DependencyProxy::GroupAccessをinclude | E-02 行5 | ○ |
| C-05 | verify_dependency_proxy_enabled!でチェック | E-02 行7, 18-20 | ○ |
| C-06 | dependency_proxyメソッドで設定取得/作成 | E-02 行14-16 | ○ |
| C-07 | group_path設定 | E-01 行3 | ○ |
| C-08 | endpoint設定 | E-01 行4 | ○ |
| C-09 | group_id設定 | E-01 行6 | ○ |
| C-10 | settings_path設定 | E-01 行7 | ○ |
| C-11 | can_clear_cacheでadmin_group権限チェック | E-01 行8 | ○ |
| C-12 | no_manifests_illustration設定 | E-01 行5 | ○ |
| C-13 | 機能No.62（パッケージレジストリ）に関連 | E-04 | ○ |
| C-14 | キャッシュクリア時にDELETE実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14について：キャッシュクリア機能はAPIエンドポイントで実装されており、このコントローラーのshowアクションからは確認できない
  - 候補：`app/controllers/groups/dependency_proxies_controller.rb`（updateアクション）/ `app/controllers/groups/dependency_proxy_for_containers_controller.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示機能が主であり、データ変更は管理者のみ
- 1: 中リスク - キャッシュクリア機能は適切な権限チェックが必要

## 6) レビュアーチェックリスト（最小）
- [ ] Dependency Proxyが無効な場合の404表示を確認
- [ ] Vue.jsアプリケーションが正しくマウントされることを確認
- [ ] マニフェスト一覧が正しく表示されることを確認
- [ ] admin_group権限がないユーザーにキャッシュクリアボタンが表示されないことを確認
- [ ] 設定リンクから正しい設定画面に遷移することを確認
- [ ] 設定が存在しない場合に自動作成されることを確認
