---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：161-Runner一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIスキーマ詳細**：フロントエンドで使用するクエリの完全な定義
  2. **Vue コンポーネント詳細構造**：GroupRunnersAppの内部実装詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/runners/index.html.haml`（行1-3）
- E-02: `app/controllers/groups/runners_controller.rb`（行17-24）
- E-03: `app/models/ci/runner.rb`（行43-47, 87-89）
- E-04: `config/routes/group.rb`（行156）
- E-05: `app/helpers/ci/runners_helper.rb`（行128-136）
- E-06: `app/assets/javascripts/ci/runner/group_runners/index.js`（行16-53）
- E-07: `app/assets/javascripts/pages/groups/runners/index/index.js`（行1-3）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行218）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/runners` | E-04 | ○ |
| C-02 | コントローラーは Groups::RunnersController#index | E-02 | ○ |
| C-03 | HAMLで#js-group-runnersにVueをマウント | E-01 | ○ |
| C-04 | read_runners権限で閲覧可能 | E-02（行9） | ○ |
| C-05 | create_runners権限で新規作成ボタン表示 | E-02（行21） | ○ |
| C-06 | register_group_runners権限で登録トークン表示 | E-02（行19） | ○ |
| C-07 | Runnerのステータスはonline/offline/never_contacted/stale | E-03（行87） | ○ |
| C-08 | Runner typeはinstance/group/project | E-03（行43-47） | ○ |
| C-09 | ONLINE_CONTACT_TIMEOUTは2時間 | E-03（行68） | ○ |
| C-10 | STALE_TIMEOUTは7日 | E-03（行79） | ○ |
| C-11 | group_runners_data_attributesでデータ属性設定 | E-05 | ○ |
| C-12 | initGroupRunners関数でVue初期化 | E-06, E-07 | ○ |
| C-13 | ApolloクライアントでGraphQL通信 | E-06（行30-32） | ○ |
| C-14 | 関連機能はRunnerレジストレーション（No.51） | E-08 | ○ |
| C-15 | ci_runnersテーブルからデータ取得 | E-03 | ○ |
| C-16 | ci_runner_namespacesでグループ関連取得 | E-03（行101-102） | ○ |
| C-17 | ci_runner_projectsでプロジェクト関連取得 | E-03（行99-100） | ○ |
| C-18 | ci_tagsでタグ情報取得 | E-03（行103-104） | ○ |
| C-19 | 権限不足時は404表示 | E-02（行63） | ○ |
| C-20 | allow_runner_registration_token?で登録トークン制御 | E-02（行18） | ○ |
| C-21 | Runner詳細画面への遷移パス | E-04 | ○ |
| C-22 | Runner新規作成画面への遷移パス | E-02（行21） | ○ |
| C-23 | 表示項目にバージョン含む | **根拠なし** | △ |
| C-24 | GraphQL APIのクエリ名とフィールド詳細 | **根拠なし** | △ |
| C-25 | Trackingイベント送信 | E-02（行23） | ○ |

## 4) 不足情報（Unknown / Missing）

- GraphQL APIスキーマ（`getGroupRunnersQuery`）の詳細定義
  - 候補：`app/assets/javascripts/ci/runner/graphql/` 配下のクエリファイル
- Vue コンポーネント`GroupRunnersApp`の詳細実装
  - 候補：`app/assets/javascripts/ci/runner/group_runners/group_runners_app.vue`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 1: 中リスク - GraphQL APIとフロントエンドの整合性
- 0: 低リスク - データベースアクセスパターン

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/runners` が正しいか実際にアクセスして確認
- [ ] 権限制御（read_runners, create_runners, register_group_runners）が正しく機能するか確認
- [ ] Runner一覧のフィルタリング機能が正常に動作するか確認
- [ ] GraphQL APIエラー時のエラーハンドリングが適切か確認
