---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：162-Runner詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL APIスキーマ詳細**：Runner詳細取得クエリの完全な定義
  2. **Vue コンポーネント詳細構造**：表示項目の詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/runners/show.html.haml`（行1-8）
- E-02: `app/controllers/groups/runners_controller.rb`（行26, 46-54）
- E-03: `app/models/ci/runner.rb`（行96, 452-475）
- E-04: `config/routes/group.rb`（行156）
- E-05: `app/assets/javascripts/pages/groups/runners/show/index.js`（行1-3）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行219）
- E-07: `app/helpers/ci/runners_helper.rb`（行54-56）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/runners/{runner_id}` | E-04 | ○ |
| C-02 | コントローラーは Groups::RunnersController#show | E-02（行26） | ○ |
| C-03 | HAMLで#js-group-runner-showにVueをマウント | E-01（行8） | ○ |
| C-04 | read_runners権限で閲覧可能 | E-02（行9） | ○ |
| C-05 | update_runner権限で編集ボタン表示 | E-02（行11, 61-64） | ○ |
| C-06 | runnerメソッドでCi::RunnersFinderを使用 | E-02（行46-54） | ○ |
| C-07 | Runner未存在時は404表示 | E-02（行50-54） | ○ |
| C-08 | short_shaでトークン短縮識別子生成 | E-03（行452-475） | ○ |
| C-09 | runner_short_nameヘルパーで表示名生成 | E-07（行54-56） | ○ |
| C-10 | has_many :runner_managersでManager関連 | E-03（行96） | ○ |
| C-11 | runner_idをdata属性として設定 | E-01（行8） | ○ |
| C-12 | edit_pathをdata属性として設定 | E-01（行8） | ○ |
| C-13 | runners_pathをdata属性として設定 | E-01（行8） | ○ |
| C-14 | 関連機能はRunnerレジストレーション（No.51） | E-06 | ○ |
| C-15 | initGroupRunnerShowでVue初期化 | E-05 | ○ |
| C-16 | ci_runnersテーブルから基本情報取得 | E-03 | ○ |
| C-17 | ci_runner_managersテーブルからManager情報取得 | E-03（行96） | ○ |
| C-18 | ci_tagsテーブルからタグ情報取得 | E-03（行103-104） | ○ |
| C-19 | ステータスはcontacted_atから計算 | E-03（行413-422） | ○ |
| C-20 | ONLINE_CONTACT_TIMEOUTは2時間 | E-03（行68） | ○ |
| C-21 | 表示項目にIPアドレス、プラットフォーム含む | **根拠なし** | △ |
| C-22 | ジョブ履歴の取得ロジック詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL APIスキーマ（`getRunnerQuery`）の詳細定義
  - 候補：`app/assets/javascripts/ci/runner/graphql/` 配下のクエリファイル
- Vue コンポーネント詳細実装
  - 候補：`app/assets/javascripts/ci/runner/group_runner_show/` 配下のVueファイル
- ジョブ履歴取得に関するGraphQLクエリ

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 1: 中リスク - 表示項目の網羅性
- 0: 低リスク - Runnerステータス計算ロジック

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/runners/{runner_id}` が正しいか実際にアクセスして確認
- [ ] Runner詳細情報が正しく表示されるか確認
- [ ] 編集ボタンの表示制御が権限に応じて正しく動作するか確認
- [ ] Runner Managerの情報が正しく表示されるか確認
- [ ] Runner未存在時に404が表示されるか確認
