---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 21
  claims_without_evidence: 3
confidence_derived: 0.88
---

# 根拠レポート：163-Runner新規登録

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：21 / 24、根拠なし：3
- 優先レビュー（高）
  1. **GraphQL mutation詳細**：runnerCreate mutationの完全な定義
  2. **CreateRunnerService詳細**：サービス内部の完全なロジック
  3. **Vue コンポーネント構造**：フォーム入力フィールドの詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/runners/new.html.haml`（行1-5）
- E-02: `app/controllers/groups/runners_controller.rb`（行38, 66-69）
- E-03: `app/models/ci/runner.rb`（行82, 91, 94, 272-273）
- E-04: `config/routes/group.rb`（行156）
- E-05: `app/assets/javascripts/pages/groups/runners/new/index.js`（行1-3）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行220）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/runners/new` | E-04 | ○ |
| C-02 | コントローラーは Groups::RunnersController#new | E-02（行38） | ○ |
| C-03 | HAMLで#js-group-new-runnerにVueをマウント | E-01（行5） | ○ |
| C-04 | create_runners権限でアクセス可能 | E-02（行10, 66-69） | ○ |
| C-05 | group_idをdata属性としてGlobalIDで設定 | E-01（行5） | ○ |
| C-06 | FORM_EDITABLEで編集可能項目定義 | E-03（行91） | ○ |
| C-07 | TAG_LIST_MAX_LENGTHは50 | E-03（行94） | ○ |
| C-08 | maximum_timeoutは10分以上 | E-03（行272-273） | ○ |
| C-09 | REGISTRATION_AVAILABILITY_TIMEは1時間 | E-03（行82） | ○ |
| C-10 | トークンプレフィックスはglrt- | E-03（行60） | ○ |
| C-11 | runner_typeは2 (group_type) | E-03（行44-47） | ○ |
| C-12 | creation_stateは0 (started) | E-03（行49-52） | ○ |
| C-13 | registration_typeは1 (authenticated_user) | E-03（行54-57） | ○ |
| C-14 | access_levelは0:not_protected / 1:ref_protected | E-03（行38-41） | ○ |
| C-15 | initGroupNewRunnerでVue初期化 | E-05 | ○ |
| C-16 | 関連機能はRunnerレジストレーション（No.51） | E-06 | ○ |
| C-17 | ci_runnersテーブルにINSERT | E-03 | ○ |
| C-18 | ci_runner_namespacesテーブルにINSERT | E-03（行101） | ○ |
| C-19 | 権限不足時は404表示 | E-02（行69） | ○ |
| C-20 | token_expires_atは計算値 | E-03（行551-559） | ○ |
| C-21 | creator_idに作成者ID設定 | E-03（行112） | ○ |
| C-22 | GraphQL mutation runnerCreate | **根拠なし** | △ |
| C-23 | CreateRunnerServiceの詳細実装 | **根拠なし** | △ |
| C-24 | プラットフォーム選択の選択肢詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL mutation `runnerCreate`の詳細定義
  - 候補：`app/graphql/mutations/ci/runner/` 配下のファイル
- CreateRunnerServiceの詳細実装
  - 候補：`app/services/ci/runners/create_runner_service.rb`
- Vue コンポーネントでのフォーム実装詳細
  - 候補：`app/assets/javascripts/ci/runner/group_new_runner/` 配下

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 1: 中リスク - GraphQL mutationとバックエンドの整合性
- 1: 中リスク - トークン生成・有効期限のロジック
- 0: 低リスク - バリデーションルール

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/runners/new` が正しいか実際にアクセスして確認
- [ ] Runner作成フォームの入力項目が正しく動作するか確認
- [ ] タグ数上限（50個）のバリデーションが機能するか確認
- [ ] タイムアウト値のバリデーション（10分以上）が機能するか確認
- [ ] 登録トークンが正しく生成・表示されるか確認
- [ ] トークンが一度しか表示されないことを確認
