---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：164-Runner編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **UpdateRunnerService詳細**：サービス内部の完全なロジック
  2. **Vue コンポーネント構造**：フォームフィールドの詳細実装

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/runners/edit.html.haml`（行1-7）
- E-02: `app/controllers/groups/runners_controller.rb`（行28, 30-35, 56-58, 60-64）
- E-03: `app/models/ci/runner.rb`（行91, 269-270, 642-652）
- E-04: `config/routes/group.rb`（行156）
- E-05: `app/assets/javascripts/pages/groups/runners/edit/index.js`（行1-3）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行221）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/runners/{runner_id}/edit` | E-04 | ○ |
| C-02 | コントローラーは Groups::RunnersController#edit | E-02（行28） | ○ |
| C-03 | HAMLで#js-group-runner-editにVueをマウント | E-01（行7） | ○ |
| C-04 | update_runner権限でアクセス可能 | E-02（行11, 60-64） | ○ |
| C-05 | runner_idをdata属性として設定 | E-01（行7） | ○ |
| C-06 | runner_pathをdata属性として設定 | E-01（行7） | ○ |
| C-07 | FORM_EDITABLEで編集可能項目定義 | E-03（行91） | ○ |
| C-08 | chronic_duration_attrで時間形式変換 | E-03（行269-270） | ○ |
| C-09 | tag_constraintsでタグバリデーション | E-03（行642-652） | ○ |
| C-10 | updateアクションでUpdateRunnerService使用 | E-02（行31） | ○ |
| C-11 | 成功時はrunner詳細画面へリダイレクト | E-02（行32） | ○ |
| C-12 | 失敗時はedit画面を再描画 | E-02（行34） | ○ |
| C-13 | runner_paramsでStrong Parameters定義 | E-02（行56-58） | ○ |
| C-14 | 関連機能はRunnerレジストレーション（No.51） | E-06 | ○ |
| C-15 | initRunnerEditでVue初期化 | E-05 | ○ |
| C-16 | ci_runnersテーブルをUPDATE | E-03 | ○ |
| C-17 | 権限不足時は404表示 | E-02（行63） | ○ |
| C-18 | access_levelは0:not_protected / 1:ref_protected | E-03（行38-41） | ○ |
| C-19 | maximum_timeout最小値は600秒（10分） | E-03（行272-273） | ○ |
| C-20 | TAG_LIST_MAX_LENGTHは50 | E-03（行94） | ○ |
| C-21 | UpdateRunnerServiceの詳細実装 | **根拠なし** | △ |
| C-22 | Vue フォームコンポーネントの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- UpdateRunnerServiceの詳細実装
  - 候補：`app/services/ci/runners/update_runner_service.rb`
- Vue コンポーネントでのフォーム実装詳細
  - 候補：`app/assets/javascripts/ci/runner/runner_edit/` 配下

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 0: 低リスク - Strong Parametersの定義
- 1: 中リスク - UpdateRunnerServiceのトランザクション処理
- 0: 低リスク - バリデーションルール

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/runners/{runner_id}/edit` が正しいか実際にアクセスして確認
- [ ] Runner編集フォームの入力項目が正しく動作するか確認
- [ ] 更新成功時にRunner詳細画面へリダイレクトされるか確認
- [ ] バリデーションエラー時にエラーメッセージが表示されるか確認
- [ ] タグとrun_untaggedの組み合わせバリデーションが機能するか確認
- [ ] maximum_timeout_human_readable形式の入力が正しく処理されるか確認
