---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：165-カスタム絵文字

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL API詳細**：createCustomEmoji、destroyCustomEmoji mutationの定義
  2. **Vue コンポーネント構造**：フォームとリスト表示の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/custom_emoji/index.html.haml`（行1-8）
- E-02: `app/controllers/groups/custom_emoji_controller.rb`（行1-8）
- E-03: `app/models/custom_emoji.rb`（行4, 12, 20-25, 62-66）
- E-04: `config/routes/group.rb`（行102）
- E-05: `app/assets/javascripts/pages/groups/custom_emoji/index.js`（行1-3）
- E-06: `app/assets/javascripts/custom_emoji/custom_emoji_bundle.js`（行1-39）
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行222）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/custom_emoji` | E-04 | ○ |
| C-02 | コントローラーは Groups::CustomEmojiController | E-02 | ○ |
| C-03 | HAMLで#js-custom-emojis-rootにVueをマウント | E-01（行3） | ○ |
| C-04 | base_pathとgroup_pathをdata属性で設定 | E-01（行3） | ○ |
| C-05 | NAME_REGEXPで名前パターン検証 | E-03（行4） | ○ |
| C-06 | 名前最大長は36文字 | E-03（行23） | ○ |
| C-07 | external=trueのみサポート | E-03（行12） | ○ |
| C-08 | TanukiEmojiとの名前重複チェック | E-03（行62-66） | ○ |
| C-09 | namespace_idでグループに関連付け | E-03（行6） | ○ |
| C-10 | creatorでユーザーに関連付け | E-03（行9） | ○ |
| C-11 | initCustomEmojisでVue初期化 | E-06 | ○ |
| C-12 | VueApollo使用 | E-06（行9） | ○ |
| C-13 | VueRouter使用 | E-06（行10, 19-23） | ○ |
| C-14 | requestIdleCallbackで非同期初期化 | E-05（行3） | ○ |
| C-15 | 関連機能はアバター管理（No.144） | E-07 | ○ |
| C-16 | custom_emojiテーブルを使用 | E-03 | ○ |
| C-17 | file項目はpublic_url検証 | E-03（行14） | ○ |
| C-18 | グループ内で名前uniqueness検証 | E-03（行21） | ○ |
| C-19 | GraphQL mutation createCustomEmoji | **根拠なし** | △ |
| C-20 | GraphQL mutation destroyCustomEmoji | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL mutation `createCustomEmoji`の詳細定義
  - 候補：`app/graphql/mutations/custom_emoji/` 配下のファイル
- GraphQL mutation `destroyCustomEmoji`の詳細定義
- Vue コンポーネントの詳細実装
  - 候補：`app/assets/javascripts/custom_emoji/components/` 配下

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - モデルバリデーション
- 1: 中リスク - 外部画像URLのセキュリティ検証
- 0: 低リスク - 標準絵文字との重複チェック

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/custom_emoji` が正しいか実際にアクセスして確認
- [ ] カスタム絵文字の作成が正しく動作するか確認
- [ ] 名前パターン（英小文字、数字、アンダースコア、ハイフン）のバリデーションが機能するか確認
- [ ] 標準絵文字との名前重複チェックが機能するか確認
- [ ] 外部画像URLの検証が正しく動作するか確認
- [ ] 削除機能が正しく動作するか確認
