---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：166-アチーブメント

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL mutation詳細**：createAchievement、awardAchievement mutationの定義
  2. **user_achievementsテーブル構造**：授与情報のテーブル構造

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/achievements/index.html.haml`（行1-15）
- E-02: `app/controllers/groups/achievements_controller.rb`（行1-20）
- E-03: `app/models/achievements/achievement.rb`（行10, 15-19）
- E-04: `config/routes/group.rb`（行191）
- E-05: `app/assets/javascripts/achievements/components/achievements_app.vue`（行1-244）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行223）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/achievements` | E-04 | ○ |
| C-02 | コントローラーは Groups::AchievementsController | E-02 | ○ |
| C-03 | HAMLで#js-achievements-appにVueをマウント | E-01（行8） | ○ |
| C-04 | viewModelにcanAdminAchievement含む | E-01（行9） | ○ |
| C-05 | viewModelにcanAwardAchievement含む | E-01（行10） | ○ |
| C-06 | viewModelにgroupFullPath含む | E-01（行11） | ○ |
| C-07 | viewModelにgitlabLogoPath含む | E-01（行13） | ○ |
| C-08 | authorize_read_achievement!で権限チェック | E-02（行8, 16-17） | ○ |
| C-09 | 名前最大255文字 | E-03（行16） | ○ |
| C-10 | 説明最大1024文字 | E-03（行19） | ○ |
| C-11 | has_many :user_achievements | E-03（行10） | ○ |
| C-12 | ENTRIES_PER_PAGE = 20 | E-05（行18） | ○ |
| C-13 | getGroupAchievementsクエリ使用 | E-05（行14, 65） | ○ |
| C-14 | getMoreUniqueUsersクエリ使用 | E-05（行15, 134-143） | ○ |
| C-15 | 関連機能はアクティビティフィード（No.136） | E-06 | ○ |
| C-16 | newアクションはindexをrender | E-02（行10-12） | ○ |
| C-17 | nextPage/prevPageでページング | E-05（行98-113） | ○ |
| C-18 | loadMoreUsersで追加読み込み | E-05（行123-133） | ○ |
| C-19 | 未授与時"Not yet awarded."表示 | E-05（行171） | ○ |
| C-20 | gitlabLogoPathでデフォルト画像 | E-05（行41-44, 213） | ○ |
| C-21 | GraphQL mutation createAchievement | **根拠なし** | △ |
| C-22 | user_achievementsテーブル構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL mutation `createAchievement`の詳細定義
  - 候補：`app/graphql/mutations/achievements/` 配下のファイル
- user_achievementsテーブル（授与情報）の詳細構造
  - 候補：`db/schema.rb`またはマイグレーションファイル

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 0: 低リスク - バリデーションルール
- 1: 中リスク - 授与機能のGraphQL実装

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/achievements` が正しいか実際にアクセスして確認
- [ ] アチーブメント一覧が正しく表示されるか確認
- [ ] 新規アチーブメント作成が正しく動作するか確認
- [ ] アチーブメント授与が正しく動作するか確認
- [ ] 権限による表示制御（admin_achievement、award_achievement）が正しく機能するか確認
- [ ] ページネーションが正しく動作するか確認
