---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：167-CRM組織一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL mutation詳細**：createOrganization、updateOrganization mutationの定義
  2. **default_rate項目**：料金フィールドの詳細仕様

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/crm/organizations/index.html.haml`（行1-17）
- E-02: `app/controllers/groups/crm/organizations_controller.rb`（行1-23）
- E-03: `app/models/customer_relations/organization.rb`（行15-18, 21-24, 74-78）
- E-04: `config/routes/group.rb`（行186）
- E-05: `app/assets/javascripts/crm/organizations/components/organizations_root.vue`（行1-261）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行224）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/crm/organizations` | E-04 | ○ |
| C-02 | コントローラーは Groups::Crm::OrganizationsController | E-02 | ○ |
| C-03 | HAMLで#js-crm-organizations-appにVueをマウント | E-01（行9） | ○ |
| C-04 | validate_crm_group!でCRMグループ検証 | E-02（行7） | ○ |
| C-05 | authorize_read_crm_organization!で権限チェック | E-02（行8, 20-22） | ○ |
| C-06 | canAdminCrmOrganizationをdata属性で設定 | E-01（行11） | ○ |
| C-07 | canReadCrmContactをdata属性で設定 | E-01（行12） | ○ |
| C-08 | groupContactsPathをdata属性で設定 | E-01（行13） | ○ |
| C-09 | enum :state で inactive/active定義 | E-03（行15-18） | ○ |
| C-10 | 名前最大255文字 | E-03（行23） | ○ |
| C-11 | 説明最大1024文字 | E-03（行24） | ○ |
| C-12 | validate_crm_groupでルートグループ検証 | E-03（行74-78） | ○ |
| C-13 | getGroupOrganizationsQueryでGraphQL取得 | E-05（行12, 47-67） | ○ |
| C-14 | getGroupOrganizationsCountByStateQueryで件数取得 | E-05（行13, 68-82） | ○ |
| C-15 | ステータスタブはActive/Inactive/All | E-05（行152-168） | ○ |
| C-16 | ソート可能項目はname/defaultRate/description | E-05（行129-140） | ○ |
| C-17 | 関連機能は組織管理（No.134） | E-06 | ○ |
| C-18 | イシュー遷移は?crm_organization_id=パラメータ付き | E-05（行116-117） | ○ |
| C-19 | newアクションはindexをrender | E-02（行10-12） | ○ |
| C-20 | editアクションはindexをrender | E-02（行14-16） | ○ |
| C-21 | GraphQL mutation createOrganization | **根拠なし** | △ |
| C-22 | default_rate項目の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL mutation `createOrganization`、`updateOrganization`の詳細定義
  - 候補：`app/graphql/mutations/customer_relations/` 配下のファイル
- default_rate（デフォルト料金）フィールドの詳細仕様
  - 候補：データベーススキーマ、EE機能として定義されている可能性

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 1: 中リスク - CRMグループ検証ロジック
- 0: 低リスク - バリデーションルール

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/crm/organizations` が正しいか実際にアクセスして確認
- [ ] CRMグループ以外でアクセスした際に404が表示されるか確認
- [ ] 組織一覧が正しく表示されるか確認
- [ ] ステータスフィルタリングが正しく動作するか確認
- [ ] 検索機能が正しく動作するか確認
- [ ] ソート機能が正しく動作するか確認
- [ ] 新規作成・編集が正しく動作するか確認
