---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：168-CRM連絡先一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **GraphQL mutation詳細**：createContact、updateContact mutationの定義
  2. **issue_contacts関連**：イシューとの紐付けテーブル構造

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/crm/contacts/index.html.haml`（行1-17）
- E-02: `app/controllers/groups/crm/contacts_controller.rb`（行1-23）
- E-03: `app/models/customer_relations/contact.rb`（行17-28, 54-56, 139-143）
- E-04: `config/routes/group.rb`（行186）
- E-05: `app/assets/javascripts/crm/contacts/components/contacts_root.vue`（行1-270）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行225）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/crm/contacts` | E-04 | ○ |
| C-02 | コントローラーは Groups::Crm::ContactsController | E-02 | ○ |
| C-03 | HAMLで#js-crm-contacts-appにVueをマウント | E-01（行9） | ○ |
| C-04 | validate_crm_group!でCRMグループ検証 | E-02（行7） | ○ |
| C-05 | authorize_read_crm_contact!で権限チェック | E-02（行8, 20-22） | ○ |
| C-06 | canAdminCrmContactをdata属性で設定 | E-01（行14） | ○ |
| C-07 | canReadCrmOrganizationをdata属性で設定 | E-01（行15） | ○ |
| C-08 | groupOrganizationsPathをdata属性で設定 | E-01（行13） | ○ |
| C-09 | enum :state で inactive/active定義 | E-03（行17-20） | ○ |
| C-10 | 名最大255文字 | E-03（行24） | ○ |
| C-11 | 姓最大255文字 | E-03（行25） | ○ |
| C-12 | メール最大255文字、グループ内unique | E-03（行26, 28） | ○ |
| C-13 | 電話番号最大32文字 | E-03（行23） | ○ |
| C-14 | 説明最大1024文字 | E-03（行27） | ○ |
| C-15 | validate_crm_groupでルートグループ検証 | E-03（行139-143） | ○ |
| C-16 | reference_prefixは'[contact:' | E-03（行54-56） | ○ |
| C-17 | getGroupContactsでGraphQL取得 | E-05（行12, 46-66） | ○ |
| C-18 | getGroupContactsCountByStateで件数取得 | E-05（行13, 67-81） | ○ |
| C-19 | デフォルトソートはLAST_NAME_ASC | E-05（行42） | ○ |
| C-20 | ソート可能項目にorganization含む | E-05（行136-141） | ○ |
| C-21 | 関連機能は組織管理（No.134） | E-06 | ○ |
| C-22 | イシュー遷移は?crm_contact_id=パラメータ付き | E-05（行115-117） | ○ |
| C-23 | GraphQL mutation createContact | **根拠なし** | △ |
| C-24 | issue_contactsテーブル構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- GraphQL mutation `createContact`、`updateContact`の詳細定義
  - 候補：`app/graphql/mutations/customer_relations/` 配下のファイル
- issue_contacts（イシューとの紐付け）テーブルの詳細構造
  - 候補：`app/models/customer_relations/issue_contact.rb`

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 1: 中リスク - CRMグループ検証ロジック
- 0: 低リスク - バリデーションルール
- 0: 低リスク - メールのユニーク制約

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/crm/contacts` が正しいか実際にアクセスして確認
- [ ] CRMグループ以外でアクセスした際に404が表示されるか確認
- [ ] 連絡先一覧が正しく表示されるか確認
- [ ] ステータスフィルタリングが正しく動作するか確認
- [ ] 検索機能が正しく動作するか確認
- [ ] ソート機能（姓、名、メール、電話、説明、組織）が正しく動作するか確認
- [ ] メールアドレスのユニーク制約が機能するか確認
- [ ] 新規作成・編集が正しく動作するか確認
