---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：169-インポート状態

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/imports/show.html.haml`（行1-9）
- E-02: `app/controllers/groups/imports_controller.rb`（行1-23）
- E-03: `app/models/group_import_state.rb`（行1-42）
- E-04: `config/routes/group.rb`（行127）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行226）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/import` | E-04 | ○ |
| C-02 | コントローラーは Groups::ImportsController | E-02（行3） | ○ |
| C-03 | ページタイトル "Import in progress" | E-01（行1） | ○ |
| C-04 | gl_loading_iconでローディング表示 | E-01（行6） | ○ |
| C-05 | 案内メッセージ表示 | E-01（行9） | ○ |
| C-06 | 完了時グループ詳細へリダイレクト | E-02（行14） | ○ |
| C-07 | 失敗時グループ作成画面へリダイレクト | E-02（行17-18） | ○ |
| C-08 | state_machineで状態管理 | E-03（行14） | ○ |
| C-09 | status初期値はcreated | E-03（行14） | ○ |
| C-10 | created = 0, started = 1, finished = 2, failed = -1 | E-03（行15-18） | ○ |
| C-11 | startイベントでcreated → started | E-03（行20-22） | ○ |
| C-12 | finishイベントでstarted → finished | E-03（行24-26） | ○ |
| C-13 | fail_opイベントでany → failed | E-03（行28-30） | ○ |
| C-14 | MAX_ERROR_LENGTH = 255 | E-03（行6） | ○ |
| C-15 | in_progress?メソッドの定義 | E-03（行39-41） | ○ |
| C-16 | 関連機能はバルクインポート（No.110） | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）

- なし（全項目に根拠あり）

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - リダイレクト処理
- 0: 低リスク - 状態管理ロジック

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/import` が正しいか実際にアクセスして確認
- [ ] インポート進行中にローディングインジケータが表示されるか確認
- [ ] インポート完了時にグループ詳細画面へリダイレクトされるか確認
- [ ] インポート失敗時にエラーメッセージが表示されるか確認
- [ ] ページリフレッシュで状態が更新されるか確認
