---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：170-インポート履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **BulkImport API詳細**：API呼び出しとデータ取得の詳細仕様
  2. **履歴データの取得元**：グループに関連する履歴データの取得方法

## 2) 参照した情報（Evidence一覧）

- E-01: `app/views/groups/import_histories/show.html.haml`（行1-3）
- E-02: `app/controllers/groups/import_histories_controller.rb`（行1-14）
- E-03: `app/assets/javascripts/groups/import_history/index.js`（行1-22）
- E-04: `app/assets/javascripts/groups/import_history/import_history.vue`（行1-30）
- E-05: `app/assets/javascripts/vue_shared/components/import/import_history_table.vue`（行1-163）
- E-06: `app/models/bulk_import.rb`（行1-60）
- E-07: `config/routes/group.rb`（行195）
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行227）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは `/{group_path}/-/import_history` | E-07 | ○ |
| C-02 | コントローラーは Groups::ImportHistoriesController | E-02（行4） | ○ |
| C-03 | ページタイトル "Import history" | E-01（行1） | ○ |
| C-04 | #js-group-import-historyでVueマウント | E-01（行3）, E-03（行5） | ○ |
| C-05 | group_nameをdata属性で渡す | E-01（行3）, E-03（行9） | ○ |
| C-06 | authorize_admin_group!で権限チェック | E-02（行8） | ○ |
| C-07 | Feature.enabled?(:group_import_history_visibility)でフラグ確認 | E-02（行11） | ○ |
| C-08 | GroupImportHistoryコンポーネントでヘッダー表示 | E-04（行17-21） | ○ |
| C-09 | ImportHistoryTableでテーブル表示 | E-05（行18-73） | ○ |
| C-10 | テーブルヘッダーはSource name/Destination/Start date/Status | E-05（行80-85） | ○ |
| C-11 | ImportHistoryTableRowで行表示 | E-05（行86-161） | ○ |
| C-12 | ImportHistoryStatusBadgeでステータス表示 | E-05（行106） | ○ |
| C-13 | hasStats/hasFailuresで詳細表示判定 | E-05（行62-70） | ○ |
| C-14 | BulkImportモデルでstate_machine管理 | E-06（行28-55） | ○ |
| C-15 | ステータス値 created(0)/started(1)/finished(2)/timeout(3)/failed(-1)/canceled(-2) | E-06（行29-34） | ○ |
| C-16 | 関連機能はバルクインポート（No.110） | E-08 | ○ |
| C-17 | BulkImport APIからデータ取得 | **根拠なし** | △ |
| C-18 | グループ関連の履歴データ取得方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

- BulkImport APIの詳細実装
  - 候補：`app/graphql/resolvers/bulk_imports/` 配下のファイル
- グループに関連するインポート履歴の取得ロジック
  - 候補：`app/finders/` または `app/services/` 配下のファイル

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - URL/ルーティング定義
- 0: 低リスク - 権限チェックロジック
- 0: 低リスク - Feature Flagチェック
- 1: 中リスク - API呼び出しとデータ取得

## 6) レビュアーチェックリスト（最小）

- [ ] URLパス `/{group_path}/-/import_history` が正しいか実際にアクセスして確認
- [ ] Feature Flag `group_import_history_visibility` が有効な環境で動作確認
- [ ] グループ管理者権限でのみアクセスできることを確認
- [ ] インポート履歴一覧が正しく表示されるか確認
- [ ] 行展開で統計情報・エラー詳細が表示されるか確認
- [ ] 各ステータス（created/started/finished/timeout/failed/canceled）の表示確認
