---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：171-Observability

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **データベーステーブル名**：observability_group_o11y_settings のカラム構造要確認
  2. **画面機能マッピングの機能No**：機能No.132との関連性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/groups/observability/show.html.haml`（行1-12）
- E-02: `app/controllers/groups/observability_controller.rb`（行1-46）
- E-03: `config/routes/group.rb`（行197-202）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行228）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`（行172）
- E-06: `app/views/groups/observability/setup/show.html.haml`（参照）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/observability/:id` | E-03 | ○ |
| C-02 | showアクションで処理される | E-02, E-03 | ○ |
| C-03 | 認証が必要（authenticate_user!） | E-02（行5） | ○ |
| C-04 | read_observability_portal権限が必要 | E-02（行43） | ○ |
| C-05 | observability_sass_featuresフィーチャーフラグが必要 | E-02（行41） | ○ |
| C-06 | 認証トークン未取得時にエラーアラート表示 | E-01（行6-7） | ○ |
| C-07 | プロビジョニング中に情報アラート表示 | E-01（行8-9） | ○ |
| C-08 | 有効化後はJSアプリケーション（#js-observability）で描画 | E-01（行12） | ○ |
| C-09 | VALID_PATHSでパスを検証 | E-02（行20, 24） | ○ |
| C-10 | ObservabilityPresenterでデータを整形 | E-02（行26） | ○ |
| C-11 | カテゴリは「グループ」 | E-05 | ○ |
| C-12 | 機能No.132（エラートラッキング）に関連 | E-04 | ○ |
| C-13 | Content Security Policyでframe-srcを設定 | E-02（行11-17） | ○ |
| C-14 | feature_category は :observability | E-02（行8） | ○ |
| C-15 | JSONレスポンスにも対応 | E-02（行28-30） | ○ |
| C-16 | ページ固有スタイル observability.scss を使用 | E-01（行3） | ○ |
| C-17 | observability_group_o11y_settingsテーブルへの INSERT | **根拠なし** | △ |
| C-18 | テーブルのカラム構造（group_id, provisioning, o11y_service_url） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-17, C-18のデータベース構造**: モデルファイルやマイグレーションファイルを直接確認していないため、テーブル構造は推測に基づいています
  - 候補: `db/migrate/*_create_observability_group_o11y_settings.rb` / `app/models/observability/group_o11y_setting.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - URL、権限チェック、表示条件分岐は全てソースコードで確認済み
- **1: 中リスク** - データベース構造は推測に基づくため、要確認

## 6) レビュアーチェックリスト（最小）
- [ ] observability_group_o11y_settingsテーブルの実際のカラム構造を確認
- [ ] ObservabilityPresenterの詳細実装を確認
- [ ] access_requestsコントローラーの処理内容を確認
- [ ] 実際の画面表示とドキュメント内容が一致するか確認
