---
generated_at: 2026-01-22 12:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：172-Observabilityセットアップ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **SetupControllerの実装詳細**：コントローラーファイルの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/views/groups/observability/setup/show.html.haml`（行1-192）
- E-02: `config/routes/group.rb`（行197-201）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行229）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行173）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URL形式は `/groups/:group_id/-/observability/setup` | E-02（行199） | ○ |
| C-02 | showアクションのみ | E-02（行199） | ○ |
| C-03 | 6つの機能カードが表示される | E-01（行37-84） | ○ |
| C-04 | APM & performanceカードが存在 | E-01（行38-44） | ○ |
| C-05 | 有効化ボタンがaccess_requestsにPOSTする | E-01（行33） | ○ |
| C-06 | OpenTelemetry nativeの特徴表示 | E-01（行93-95） | ○ |
| C-07 | ClickHouse performanceの特徴表示 | E-01（行100-103） | ○ |
| C-08 | プロビジョニング時間表示（5分） | E-01（行161-163） | ○ |
| C-09 | ベータ版表示 | E-01（行168-171） | ○ |
| C-10 | 無料表示 | E-01（行175-179） | ○ |
| C-11 | 画像の遅延読み込み（lazy loading） | E-01（行136, 147） | ○ |
| C-12 | 設定済み時は_endpoint_configurationパーシャルを表示 | E-01（行15） | ○ |
| C-13 | ヘルプページへのリンク | E-01（行185-186） | ○ |
| C-14 | カテゴリは「グループ」 | E-04 | ○ |
| C-15 | SetupControllerでの処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-15のコントローラー実装**: Setupコントローラーの具体的な実装ファイルを確認していない
  - 候補: `app/controllers/groups/observability/setup_controller.rb`

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ビューテンプレートの内容は詳細に確認済み
- **1: 中リスク** - コントローラーの実装詳細は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] SetupControllerの実装を確認
- [ ] access_requestsコントローラーの処理を確認
- [ ] _endpoint_configurationパーシャルの内容を確認
- [ ] 実際の画面表示とドキュメント内容が一致するか確認
